/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners.handlers.interacts;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.world.CropGrowLogEntry;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import io.github.InsiderAnh.StellarProtect.listeners.handlers.GenericHandler;
import lombok.NonNull;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PlayerGrowCropHandler
extends GenericHandler {
    @Override
    public GenericHandler canHandle(@NonNull Block block, @Nullable ItemStack itemStack) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        if (itemStack != null && StellarProtect.getInstance().getProtectNMS().canGrow(block) && itemStack.getType().name().contains("BONE")) {
            return this;
        }
        return null;
    }

    @Override
    public void handle(Player player, @NonNull Block block, ItemStack itemStack) {
        if (block == null) {
            throw new NullPointerException("block is marked non-null but is null");
        }
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        LoggerCache.addLog(new CropGrowLogEntry(playerProtect.getPlayerId(), block));
    }
}

