/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.managers;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.economy.PlayerEconomyEntry;
import io.github.InsiderAnh.StellarProtect.enums.MoneyVarType;
import io.github.InsiderAnh.StellarProtect.hooks.tasks.TaskCanceller;
import io.github.InsiderAnh.StellarProtect.utils.StringCleanerUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class EconomyManager {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private TaskCanceller taskCanceller;

    public void load() {
        if (this.taskCanceller != null) {
            this.taskCanceller.cancel();
        }
        if (this.plugin.getConfigManager().isEconomyDisabled() || this.plugin.getEconomy() == null) {
            return;
        }
        this.taskCanceller = this.plugin.getStellarTaskHook(() -> {
            for (Player player : Bukkit.getOnlinePlayers()) {
                double balance;
                PlayerProtect playerProtect;
                if (!player.isOnline() || (playerProtect = PlayerProtect.getPlayer(player)) == null || (balance = StringCleanerUtils.limitTo2Decimals(this.plugin.getEconomy().getBalance((OfflinePlayer)player))) == playerProtect.getLastEconomyBalance()) continue;
                double difference = balance - playerProtect.getLastEconomyBalance();
                playerProtect.setLastEconomyBalance(balance);
                LoggerCache.addLog(new PlayerEconomyEntry(playerProtect.getPlayerId(), player.getLocation(), MoneyVarType.VAULT, difference));
            }
        }).runTaskTimerAsynchronously(0L, (long)this.plugin.getConfigManager().getEconomyCheckInterval() * 20L);
    }
}

