/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.utils;

import io.github.InsiderAnh.StellarProtect.data.InspectSession;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;

public class PaginationUtils {
    public static TextComponent buildPagination(String pageStart, String pageClick, int currentPage, int perPage, int maxPage, PlayerProtect playerProtect) {
        String click;
        int endPage;
        int startPage;
        if (currentPage < 1 || maxPage < 1 || currentPage > maxPage) {
            return new TextComponent(pageStart);
        }
        TextComponent complete = new TextComponent(pageStart);
        complete.addExtra(currentPage + "/" + maxPage + "  \u00a77(\u00a7f");
        boolean showStartDots = false;
        boolean showEndDots = false;
        if (maxPage <= 7) {
            startPage = 1;
            endPage = maxPage;
        } else if (currentPage <= 4) {
            startPage = 1;
            endPage = 7;
            showEndDots = true;
        } else if (currentPage >= maxPage - 3) {
            startPage = maxPage - 6;
            endPage = maxPage;
            showStartDots = true;
        } else {
            startPage = currentPage - 3;
            endPage = currentPage + 3;
            showStartDots = true;
            showEndDots = true;
        }
        boolean firstElement = true;
        if (showStartDots) {
            String pageArgument = PaginationUtils.getPage(playerProtect, 1, perPage);
            click = pageClick.replace("<page>", "1");
            TextComponent start = currentPage == 1 ? new TextComponent("\u00a7n1\u00a7r") : new TextComponent("1");
            start.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect " + pageArgument));
            start.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)click)));
            complete.addExtra((BaseComponent)start);
            complete.addExtra((BaseComponent)new TextComponent(" \u00a77... \u00a7f"));
            firstElement = false;
        }
        for (int page = startPage; page <= endPage; ++page) {
            String pageArgument = PaginationUtils.getPage(playerProtect, page, perPage);
            String click2 = pageClick.replace("<page>", String.valueOf(page));
            StringBuilder pageBuilder = new StringBuilder();
            if (!firstElement) {
                pageBuilder.append("\u00a7f");
            }
            firstElement = false;
            if (page == currentPage) {
                pageBuilder.append("\u00a7n").append(page).append("\u00a7r");
            } else {
                pageBuilder.append(page);
            }
            if (page < endPage || showEndDots) {
                pageBuilder.append(" \u00a77| ");
            }
            TextComponent component = new TextComponent(pageBuilder.toString());
            component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect " + pageArgument));
            component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)click2)));
            complete.addExtra((BaseComponent)component);
        }
        if (showEndDots) {
            String pageArgument = PaginationUtils.getPage(playerProtect, maxPage, perPage);
            click = pageClick.replace("<page>", String.valueOf(maxPage));
            complete.addExtra((BaseComponent)new TextComponent("\u00a77... \u00a7f"));
            TextComponent pageComponent = currentPage == maxPage ? new TextComponent("\u00a7n" + maxPage + "\u00a7r") : new TextComponent(String.valueOf(maxPage));
            pageComponent.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/stellarprotect " + pageArgument));
            pageComponent.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, TextComponent.fromLegacyText((String)click)));
            complete.addExtra((BaseComponent)pageComponent);
        }
        complete.addExtra("\u00a77)");
        return complete;
    }

    static String getPage(PlayerProtect playerProtect, int page, int perPage) {
        String pageArgument;
        if (playerProtect.getLookupSession() != null) {
            pageArgument = "nl p:" + page + "-" + perPage;
        } else if (playerProtect.getInspectSession() != null) {
            InspectSession inspectSession = playerProtect.getInspectSession();
            pageArgument = "ni l:" + inspectSession.getArgument() + " p:" + page + "-" + perPage;
        } else {
            return "";
        }
        return pageArgument;
    }
}

