/*
 * Decompiled with CFR 0.152.
 */
package com.cjcrafter.foliascheduler.reflectionremapper;

import com.cjcrafter.foliascheduler.mappingio.tree.MappingTree;
import com.cjcrafter.foliascheduler.reflectionremapper.ReflectionRemapper;
import com.cjcrafter.foliascheduler.reflectionremapper.internal.util.StringPool;
import com.cjcrafter.foliascheduler.reflectionremapper.internal.util.Util;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;

final class ReflectionRemapperImpl
implements ReflectionRemapper {
    private final Map<String, ClassMapping> mappingsByObf;
    private final Map<String, ClassMapping> mappingsByDeobf;

    private ReflectionRemapperImpl(Set<ClassMapping> mappings) {
        this.mappingsByObf = Collections.unmodifiableMap(mappings.stream().collect(Collectors.toMap(ClassMapping::obfName, Function.identity())));
        this.mappingsByDeobf = Collections.unmodifiableMap(mappings.stream().collect(Collectors.toMap(ClassMapping::deobfName, Function.identity())));
    }

    @Override
    public String remapClassName(String className) {
        @Nullable ClassMapping map = this.mappingsByDeobf.get(className);
        if (map == null) {
            return className;
        }
        return map.obfName();
    }

    @Override
    public String remapFieldName(Class<?> holdingClass, String fieldName) {
        @Nullable ClassMapping clsMap = this.mappingsByObf.get(holdingClass.getName());
        if (clsMap == null) {
            return fieldName;
        }
        return clsMap.fieldsDeobfToObf().getOrDefault(fieldName, fieldName);
    }

    @Override
    public String remapMethodName(Class<?> holdingClass, String methodName, Class<?> ... paramTypes) {
        @Nullable ClassMapping clsMap = this.mappingsByObf.get(holdingClass.getName());
        if (clsMap == null) {
            return methodName;
        }
        return clsMap.methods().getOrDefault(ReflectionRemapperImpl.methodKey(methodName, paramTypes), methodName);
    }

    private static String methodKey(String deobfName, Class<?> ... paramTypes) {
        return deobfName + ReflectionRemapperImpl.paramsDescriptor(paramTypes);
    }

    private static String methodKey(String deobfName, String obfMethodDesc) {
        return deobfName + ReflectionRemapperImpl.paramsDescFromMethodDesc(obfMethodDesc);
    }

    private static String paramsDescriptor(Class<?> ... params) {
        StringBuilder builder = new StringBuilder();
        for (Class<?> param : params) {
            builder.append(Util.descriptorString(param));
        }
        return builder.toString();
    }

    private static String paramsDescFromMethodDesc(String methodDescriptor) {
        String ret = methodDescriptor.substring(1);
        ret = ret.substring(0, ret.indexOf(")"));
        return ret;
    }

    static ReflectionRemapperImpl fromMappingTree(MappingTree tree, String fromNamespace, String toNamespace) {
        StringPool pool = new StringPool();
        HashSet<ClassMapping> mappings = new HashSet<ClassMapping>();
        for (MappingTree.ClassMapping classMapping : tree.getClasses()) {
            HashMap<String, String> fields = new HashMap<String, String>();
            for (MappingTree.FieldMapping fieldMapping : classMapping.getFields()) {
                fields.put(pool.string(Objects.requireNonNull(fieldMapping.getName(fromNamespace))), pool.string(Objects.requireNonNull(fieldMapping.getName(toNamespace))));
            }
            HashMap<String, String> methods = new HashMap<String, String>();
            for (MappingTree.MethodMapping method : classMapping.getMethods()) {
                methods.put(pool.string(ReflectionRemapperImpl.methodKey(Objects.requireNonNull(method.getName(fromNamespace)), Objects.requireNonNull(method.getDesc(toNamespace)))), pool.string(Objects.requireNonNull(method.getName(toNamespace))));
            }
            ClassMapping classMapping2 = new ClassMapping(Objects.requireNonNull(classMapping.getName(toNamespace)).replace('/', '.'), Objects.requireNonNull(classMapping.getName(fromNamespace)).replace('/', '.'), Collections.unmodifiableMap(fields), Collections.unmodifiableMap(methods));
            mappings.add(classMapping2);
        }
        return new ReflectionRemapperImpl(mappings);
    }

    private static final class ClassMapping {
        private final String obfName;
        private final String deobfName;
        private final Map<String, String> fieldsDeobfToObf;
        private final Map<String, String> methods;

        private ClassMapping(String obfName, String deobfName, Map<String, String> fieldsDeobfToObf, Map<String, String> methods) {
            this.obfName = obfName;
            this.deobfName = deobfName;
            this.fieldsDeobfToObf = fieldsDeobfToObf;
            this.methods = methods;
        }

        public String obfName() {
            return this.obfName;
        }

        public String deobfName() {
            return this.deobfName;
        }

        public Map<String, String> fieldsDeobfToObf() {
            return this.fieldsDeobfToObf;
        }

        public Map<String, String> methods() {
            return this.methods;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            @Nullable ClassMapping that = (ClassMapping)obj;
            return Objects.equals(this.obfName, that.obfName) && Objects.equals(this.deobfName, that.deobfName) && Objects.equals(this.fieldsDeobfToObf, that.fieldsDeobfToObf) && Objects.equals(this.methods, that.methods);
        }

        public int hashCode() {
            return Objects.hash(this.obfName, this.deobfName, this.fieldsDeobfToObf, this.methods);
        }

        public String toString() {
            return "ClassMapping[obfName=" + this.obfName + ", deobfName=" + this.deobfName + ", fieldsDeobfToObf=" + this.fieldsDeobfToObf + ", methods=" + this.methods + ']';
        }
    }
}

