/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect;

import com.cjcrafter.foliascheduler.util.MinecraftVersions;
import com.cjcrafter.foliascheduler.util.ServerVersions;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.StellarProtect.api.ColorUtils;
import io.github.InsiderAnh.StellarProtect.api.ProtectNMS;
import io.github.InsiderAnh.StellarProtect.api.events.EventLogicHandler;
import io.github.InsiderAnh.StellarProtect.bstats.MetricsLite;
import io.github.InsiderAnh.StellarProtect.commands.StellarProtectCMD;
import io.github.InsiderAnh.StellarProtect.database.ProtectDatabase;
import io.github.InsiderAnh.StellarProtect.enums.MinecraftVersion;
import io.github.InsiderAnh.StellarProtect.hooks.StellarTaskHook;
import io.github.InsiderAnh.StellarProtect.hooks.tasks.BukkitTaskHook;
import io.github.InsiderAnh.StellarProtect.hooks.tasks.FoliaTaskHook;
import io.github.InsiderAnh.StellarProtect.inspect.InspectHandler;
import io.github.InsiderAnh.StellarProtect.listeners.BlockFormListener;
import io.github.InsiderAnh.StellarProtect.listeners.BlockListener;
import io.github.InsiderAnh.StellarProtect.listeners.BucketListener;
import io.github.InsiderAnh.StellarProtect.listeners.ChatListener;
import io.github.InsiderAnh.StellarProtect.listeners.CraftListener;
import io.github.InsiderAnh.StellarProtect.listeners.ExplodeListener;
import io.github.InsiderAnh.StellarProtect.listeners.InspectListener;
import io.github.InsiderAnh.StellarProtect.listeners.PickUpDropListener;
import io.github.InsiderAnh.StellarProtect.listeners.PlayerLogListener;
import io.github.InsiderAnh.StellarProtect.listeners.SignListener;
import io.github.InsiderAnh.StellarProtect.listeners.blocks.CropGrowListener;
import io.github.InsiderAnh.StellarProtect.listeners.common.PlayerListener;
import io.github.InsiderAnh.StellarProtect.listeners.versions.EventVersionHandler;
import io.github.InsiderAnh.StellarProtect.managers.CacheManager;
import io.github.InsiderAnh.StellarProtect.managers.ConfigManager;
import io.github.InsiderAnh.StellarProtect.managers.ItemsManager;
import io.github.InsiderAnh.StellarProtect.managers.LangManager;
import io.github.InsiderAnh.StellarProtect.managers.RestoreManager;
import io.github.InsiderAnh.StellarProtect.managers.TrackManager;
import io.github.InsiderAnh.StellarProtect.restore.BlockRestore;
import io.github.InsiderAnh.StellarProtect.trackers.ChestTransactionTracker;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class StellarProtect
extends JavaPlugin {
    private static StellarProtect instance;
    private final ConfigManager configManager;
    private final LangManager langManager;
    private final CacheManager cacheManager;
    private final ItemsManager itemsManager;
    private final RestoreManager restoreManager;
    private final TrackManager trackManager;
    private final ProtectDatabase protectDatabase;
    private final InspectHandler inspectHandler;
    private final EventLogicHandler eventLogicHandler;
    private ChestTransactionTracker chestTransactionTracker;
    private ListeningExecutorService executor;
    private ListeningExecutorService lookupExecutor;
    private ListeningExecutorService joinExecutor;
    private ProtectNMS protectNMS;
    private ColorUtils colorUtils;
    private String version;
    private MinecraftVersion localVersion;
    private String completer;
    private MetricsLite bstats;

    public StellarProtect() {
        instance = this;
        this.configManager = new ConfigManager();
        this.langManager = new LangManager();
        this.cacheManager = new CacheManager();
        this.itemsManager = new ItemsManager();
        this.restoreManager = new RestoreManager();
        this.trackManager = new TrackManager();
        this.protectDatabase = new ProtectDatabase();
        this.inspectHandler = new InspectHandler();
        this.eventLogicHandler = new EventVersionHandler();
    }

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
        this.protectDatabase.connect();
        this.reload();
        this.executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(this.configManager.getMaxCores(), this.configManager.getMaxCores(), 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.lookupExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.joinExecutor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(2, 2, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        this.protectDatabase.load();
        this.cacheManager.load();
        this.chestTransactionTracker = new ChestTransactionTracker();
        for (Listener listener : this.getListeners()) {
            this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.chestTransactionTracker, (Plugin)this);
        this.getCommand("stellarprotect").setExecutor((CommandExecutor)new StellarProtectCMD());
        this.bstats = new MetricsLite((Plugin)this, 26624);
    }

    public void reload() {
        this.reloadConfig();
        this.configManager.load();
        this.langManager.load();
        this.cacheManager.load();
        this.trackManager.load();
    }

    public void onDisable() {
        this.protectDatabase.close();
        this.bstats.shutdown();
    }

    HashSet<Listener> getListeners() {
        return new HashSet<Listener>(Arrays.asList(new BlockFormListener(), new SignListener(), new ExplodeListener(), new BucketListener(), new BlockListener(), new CropGrowListener(), new PlayerListener(), new InspectListener(), new CraftListener(), new ChatListener(), new PickUpDropListener(), new PlayerLogListener()));
    }

    public ProtectNMS getProtectNMS() {
        if (this.protectNMS == null) {
            this.loadNMS();
        }
        return this.protectNMS;
    }

    public ColorUtils getColorUtils() {
        if (this.colorUtils == null) {
            this.loadNMS();
        }
        return this.colorUtils;
    }

    public void loadNMS() {
        String cbPackage = Bukkit.getServer().getClass().getPackage().getName();
        String detectedVersion = cbPackage.substring(cbPackage.lastIndexOf(46) + 1);
        if (!detectedVersion.startsWith("v")) {
            detectedVersion = Bukkit.getServer().getBukkitVersion();
        }
        this.version = detectedVersion;
        this.getLogger().info("Detected Minecraft version: " + this.version);
        this.localVersion = MinecraftVersion.get(this.version);
        if (this.localVersion == null) {
            Bukkit.getLogger().warning("[StellarProtect] No found Minecraft version " + this.version + ". If you want to support this version, contact InsiderAnh.");
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.completer = this.localVersion.equals((Object)MinecraftVersion.v1_8) ? "v1_8_R3" : (this.localVersion.equals((Object)MinecraftVersion.v1_9) ? "v1_9_R4" : (this.localVersion.equals((Object)MinecraftVersion.v1_12) ? "v1_12_R2" : (this.localVersion.equals((Object)MinecraftVersion.v1_13) ? "v1_13_R2" : (this.localVersion.equals((Object)MinecraftVersion.v1_16) ? "v1_16_R5" : (this.localVersion.equals((Object)MinecraftVersion.v1_17) ? "v1_17_R1" : this.localVersion.name())))));
        this.getLogger().info("Loaded " + this.completer + " version.");
        this.protectNMS = Class.forName("io.github.InsiderAnh.StellarProtect.nms." + this.completer + ".ProtectNMS_" + this.completer).asSubclass(ProtectNMS.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        this.colorUtils = Class.forName("io.github.InsiderAnh.StellarProtect.nms." + this.completer + ".ColorUtils_" + this.completer).asSubclass(ColorUtils.class).getConstructor(new Class[0]).newInstance(new Object[0]);
        Listener listener = Class.forName("io.github.InsiderAnh.StellarProtect.nms." + this.completer + ".listeners.BlockListener_" + this.completer).asSubclass(Listener.class).getConstructor(EventLogicHandler.class).newInstance(this.eventLogicHandler);
        this.getServer().getPluginManager().registerEvents(listener, (Plugin)this);
    }

    public BlockRestore getBlockRestore(String data) {
        if (this.completer == null) {
            this.loadNMS();
        }
        return Class.forName("io.github.InsiderAnh.StellarProtect.nms." + this.completer + ".BlockRestore_" + this.completer).asSubclass(BlockRestore.class).getConstructor(String.class).newInstance(data);
    }

    public StellarTaskHook getStellarTaskHook(Runnable runnable) {
        if (MinecraftVersions.WILD_UPDATE.isAtLeast() && ServerVersions.isFolia()) {
            return new FoliaTaskHook(runnable);
        }
        return new BukkitTaskHook(runnable);
    }

    @Generated
    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    @Generated
    public LangManager getLangManager() {
        return this.langManager;
    }

    @Generated
    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    @Generated
    public ItemsManager getItemsManager() {
        return this.itemsManager;
    }

    @Generated
    public RestoreManager getRestoreManager() {
        return this.restoreManager;
    }

    @Generated
    public TrackManager getTrackManager() {
        return this.trackManager;
    }

    @Generated
    public ProtectDatabase getProtectDatabase() {
        return this.protectDatabase;
    }

    @Generated
    public InspectHandler getInspectHandler() {
        return this.inspectHandler;
    }

    @Generated
    public EventLogicHandler getEventLogicHandler() {
        return this.eventLogicHandler;
    }

    @Generated
    public ChestTransactionTracker getChestTransactionTracker() {
        return this.chestTransactionTracker;
    }

    @Generated
    public ListeningExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public ListeningExecutorService getLookupExecutor() {
        return this.lookupExecutor;
    }

    @Generated
    public ListeningExecutorService getJoinExecutor() {
        return this.joinExecutor;
    }

    @Generated
    public String getVersion() {
        return this.version;
    }

    @Generated
    public MinecraftVersion getLocalVersion() {
        return this.localVersion;
    }

    @Generated
    public String getCompleter() {
        return this.completer;
    }

    @Generated
    public MetricsLite getBstats() {
        return this.bstats;
    }

    @Generated
    public static StellarProtect getInstance() {
        return instance;
    }
}

