/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.cache.keys;

import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.utils.WorldUtils;
import java.util.Objects;
import lombok.Generated;
import org.bukkit.Location;

public class LocationCache {
    private final int worldId;
    private final int x;
    private final int y;
    private final int z;

    public LocationCache(int worldId, int x, int y, int z) {
        this.worldId = worldId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static LocationCache of(LogEntry logEntry) {
        return LocationCache.of(logEntry.getWorldId(), (int)logEntry.getX(), (int)logEntry.getY(), (int)logEntry.getZ());
    }

    public static LocationCache of(Location location) {
        return new LocationCache(WorldUtils.getShortId(location.getWorld().getName()), location.getBlockX(), location.getBlockY(), location.getBlockZ());
    }

    public static LocationCache of(int worldId, int x, int y, int z) {
        return new LocationCache(worldId, x, y, z);
    }

    public boolean isInside(double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        return minX <= (double)this.x && maxX >= (double)this.x && minY <= (double)this.y && maxY >= (double)this.y && minZ <= (double)this.z && maxZ >= (double)this.z;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationCache that = (LocationCache)o;
        return this.worldId == that.worldId && this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.worldId, this.x, this.y, this.z);
    }

    @Generated
    public int getWorldId() {
        return this.worldId;
    }

    @Generated
    public int getX() {
        return this.x;
    }

    @Generated
    public int getY() {
        return this.y;
    }

    @Generated
    public int getZ() {
        return this.z;
    }
}

