/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.sql;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.ItemsRepository;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import io.github.InsiderAnh.StellarProtect.utils.InventorySerializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bukkit.inventory.ItemStack;

public class ItemsRepositorySQL
implements ItemsRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final Connection connection;

    public ItemsRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public void saveItems(List<ItemTemplate> itemTemplates) {
        this.stellarProtect.getExecutor().execute(() -> {
            String sql = "INSERT OR REPLACE INTO " + this.stellarProtect.getConfigManager().getTablesItemTemplates() + " (id, base64, s) VALUES (?, ?, ?)";
            try (PreparedStatement statement = this.connection.prepareStatement(sql);){
                this.connection.setAutoCommit(false);
                int batchSize = 0;
                int maxBatchSize = 1000;
                for (ItemTemplate template : itemTemplates) {
                    statement.setLong(1, template.getId());
                    statement.setString(2, template.getBase64());
                    statement.setByte(3, template.getShorted());
                    statement.addBatch();
                    if (++batchSize < maxBatchSize) continue;
                    statement.executeBatch();
                    this.connection.commit();
                    statement.clearBatch();
                    batchSize = 0;
                }
                if (batchSize > 0) {
                    statement.executeBatch();
                }
                this.connection.commit();
                Debugger.debugSave("Saved " + itemTemplates.size() + " item templates in SQLite");
            }
            catch (SQLException e) {
                Debugger.debugSave("Error on save items in SQLite: " + e.getMessage());
            }
        });
    }

    @Override
    public void updateItemUsageInDatabase(long templateId, int quantity) {
        this.stellarProtect.getExecutor().execute(() -> {
            String sql = "UPDATE " + this.stellarProtect.getConfigManager().getTablesItemTemplates() + " SET access_count = access_count + 1,last_accessed = CURRENT_TIMESTAMP,total_quantity_used = total_quantity_used + ?WHERE id = ?";
            try (PreparedStatement stmt = this.connection.prepareStatement(sql);){
                stmt.setInt(1, quantity);
                stmt.setLong(2, templateId);
                stmt.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    @Override
    public void loadMostUsedItems() {
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        executor.execute(() -> {
            String sql = "SELECT id, base64, s, access_count, last_accessed, total_quantity_used, created_at FROM " + this.stellarProtect.getConfigManager().getTablesItemTemplates() + " ORDER BY access_count DESC, total_quantity_used DESC LIMIT 5000";
            try (PreparedStatement statement = this.connection.prepareStatement(sql);
                 ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    long id = resultSet.getLong("id");
                    String base64 = resultSet.getString("base64");
                    byte shorted = resultSet.getByte("s");
                    String fullBase64 = shorted == 1 ? "rO0ABXNyABpvcmcuYnVra2l0LnV0aWwuaW8uV3JhcHBlcvJQR+zxEm8FAgABTAADbWFwdAAPTGphdmEvdXRpbC9NYXA7eHBzcgA1Y29tLmdvb2dsZS5jb21tb24uY29sbGVjdC5JbW11dGFibGVNYXAkU2VyaWFsaXplZEZvcm0AAAAAAAAAAAIAAkwABGtleXN0ABJMamF2YS9sYW5nL09iamVjdDtMAAZ2YWx1ZXNxAH4ABHhwdXIAE1tMamF2YS5sYW5nLk9iamVjdDuQzlifEHMpbAIAAHhwAAAABXQAAj09dAALRGF0YVZlcnNpb250AAJpZHQABWNvdW50dAAOc2NoZW1hX3ZlcnNpb251cQB+AAYAAAAFdAAeb3JnLmJ1a2tpdC5pbnZlbnRvcnkuSXRlbVN0YWNrc3IAEWphdmEubGFuZy5JbnRlZ2VyEuKgpPeB" + base64 : base64;
                    ItemStack bukkitItem = InventorySerializable.itemStackFromBase64(fullBase64);
                    ItemTemplate template = new ItemTemplate(id, bukkitItem, fullBase64);
                    this.stellarProtect.getItemsManager().loadItemReference(template, fullBase64);
                }
                this.stellarProtect.getLogger().info("Loaded " + this.stellarProtect.getItemsManager().getItemReferenceCount() + " item references.");
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().info("Error en loadMostUsedItems: " + e.getMessage());
            }
        });
        executor.shutdown();
    }
}

