/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.bson.io.BsonOutput;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.LegacyMessage;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.MessageSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.OpCode;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.RequestMessage;

class GetMoreMessage
extends LegacyMessage {
    private final long cursorId;
    private final int numberToReturn;

    GetMoreMessage(String collectionName, long cursorId, int numberToReturn) {
        super(collectionName, OpCode.OP_GETMORE, MessageSettings.builder().build());
        this.cursorId = cursorId;
        this.numberToReturn = numberToReturn;
    }

    public long getCursorId() {
        return this.cursorId;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput) {
        this.writeGetMore(bsonOutput);
        return new RequestMessage.EncodingMetadata(bsonOutput.getPosition());
    }

    private void writeGetMore(BsonOutput buffer) {
        buffer.writeInt32(0);
        buffer.writeCString(this.getCollectionName());
        buffer.writeInt32(this.numberToReturn);
        buffer.writeInt64(this.cursorId);
    }
}

