/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoInternalException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.async.SingleResultCallback;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.ResponseBuffers;

abstract class ResponseCallback
implements SingleResultCallback<ResponseBuffers> {
    private volatile boolean closed;
    private final ServerAddress serverAddress;
    private final long requestId;

    ResponseCallback(long requestId, ServerAddress serverAddress) {
        this.serverAddress = serverAddress;
        this.requestId = requestId;
    }

    protected ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    protected long getRequestId() {
        return this.requestId;
    }

    @Override
    public void onResult(ResponseBuffers responseBuffers, Throwable t) {
        if (this.closed) {
            throw new MongoInternalException("Callback should not be invoked more than once");
        }
        this.closed = true;
        if (responseBuffers != null) {
            this.callCallback(responseBuffers, t);
        } else {
            this.callCallback(null, t);
        }
    }

    protected abstract void callCallback(ResponseBuffers var1, Throwable var2);
}

