/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.listeners.common;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        this.plugin.getJoinExecutor().execute(() -> {
            PlayerProtect playerProtect = this.plugin.getProtectDatabase().loadOrCreatePlayer(event.getPlayer());
            if (playerProtect != null) {
                playerProtect.create();
                PlayerCache.cacheName(playerProtect.getPlayerId(), event.getPlayer().getName());
            }
        });
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        PlayerProtect playerProtect = PlayerProtect.removePlayer(event.getPlayer());
        if (playerProtect == null) {
            return;
        }
        PlayerCache.removeCacheName(playerProtect.getPlayerId());
    }
}

