/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.utils;

import lombok.Generated;

public final class TimeUtils {
    private static final long MINUTE = 60L;
    private static final long HOUR = 3600L;
    private static final long DAY = 86400L;
    private static final long WEEK = 604800L;
    private static final long MONTH = 2592000L;
    private static final long YEAR = 31536000L;

    public static String formatMillisAsAgo(long createdAt) {
        long currentTime = System.currentTimeMillis();
        long timeAgo = currentTime - createdAt;
        return TimeUtils.formatDuration(timeAgo);
    }

    public static String formatDuration(long durationMillis) {
        long totalSeconds = durationMillis / 1000L;
        if (totalSeconds < 60L) {
            return String.format("00:%02d/s ago", totalSeconds);
        }
        if (totalSeconds < 3600L) {
            long minutes = totalSeconds / 60L;
            long seconds = totalSeconds % 60L;
            return String.format("%02d:%02d/m ago", minutes, seconds);
        }
        if (totalSeconds < 86400L) {
            long hours = totalSeconds / 3600L;
            long minutes = totalSeconds % 3600L / 60L;
            return String.format("%02d:%02d/h ago", hours, minutes);
        }
        if (totalSeconds < 604800L) {
            long days = totalSeconds / 86400L;
            long hours = totalSeconds % 86400L / 3600L;
            return String.format("%02d:%02d/d ago", days, hours);
        }
        if (totalSeconds < 2592000L) {
            long weeks = totalSeconds / 604800L;
            long days = totalSeconds % 604800L / 86400L;
            return String.format("%02d:%02d/w ago", weeks, days);
        }
        if (totalSeconds < 31536000L) {
            long months = totalSeconds / 2592000L;
            long weeks = totalSeconds % 2592000L / 604800L;
            return String.format("%02d:%02d/M ago", months, weeks);
        }
        long years = totalSeconds / 31536000L;
        long months = totalSeconds % 31536000L / 2592000L;
        return String.format("%02d:%02d/y ago", years, months);
    }

    @Generated
    private TimeUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

