/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.commands.arguments;

import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.arguments.ArgumentsParser;
import io.github.insideranh.stellarprotect.arguments.HashTagsArg;
import io.github.insideranh.stellarprotect.arguments.RadiusArg;
import io.github.insideranh.stellarprotect.arguments.TimeArg;
import io.github.insideranh.stellarprotect.commands.StellarArgument;
import io.github.insideranh.stellarprotect.data.PlayerProtect;
import io.github.insideranh.stellarprotect.data.RestoreSession;
import io.github.insideranh.stellarprotect.enums.ActionType;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RestoreArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        HashTagsArg hashTagsArg = new HashTagsArg(arguments);
        TimeArg timeArg = ArgumentsParser.parseTime(arguments);
        RadiusArg radiusArg = ArgumentsParser.parseRadiusOrNull(player, arguments, player.getLocation());
        if (radiusArg == null) {
            radiusArg = new RadiusArg(player.getLocation(), 10.0, -1);
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.specifyRadius");
        }
        LinkedList<ActionType> actionTypes = new LinkedList<ActionType>(Arrays.asList(ActionType.BLOCK_BREAK, ActionType.BLOCK_PLACE, ActionType.BUCKET_EMPTY, ActionType.BUCKET_FILL, ActionType.BLOCK_SPREAD, ActionType.INVENTORY_TRANSACTION));
        if (hashTagsArg.isEntities()) {
            actionTypes.add(ActionType.KILL_ENTITY);
        }
        if (hashTagsArg.isSession()) {
            RestoreSession session = new RestoreSession(player, timeArg, radiusArg, actionTypes.stream().map(ActionType::getId).collect(Collectors.toList()), hashTagsArg.isVerbose(), hashTagsArg.isSilent());
            playerProtect.setRestoreSession(session);
            this.plugin.getRestoreSessionManager().showRestoreSession(session);
            return;
        }
        this.executeRestore(player, hashTagsArg.isPreview(), hashTagsArg.isVerbose(), hashTagsArg.isSilent(), timeArg, radiusArg, actionTypes);
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        if (arguments.length >= 1) {
            String currentArg = arguments[arguments.length - 1].toLowerCase();
            if (currentArg.startsWith("t:") || currentArg.startsWith("time:")) {
                return Arrays.asList("t:1h-2h", "t:1d", "t:1w", "t:1mo");
            }
            if (currentArg.startsWith("r:") || currentArg.startsWith("radius:")) {
                return Arrays.asList("r:10", "r:20", "r:#world", "r:10,10,10");
            }
            return Stream.of("t:1h", "r:10", "#session", "#preview", "#verbose", "#silent", "#count", "#entities").filter(name -> name.contains(currentArg)).collect(Collectors.toList());
        }
        return Arrays.asList("t:1h", "r:10", "#session", "#preview", "#verbose", "#silent", "#count", "#entities");
    }

    public void executeRestore(Player player, boolean preview, boolean verbose, boolean silent, TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes) {
        int BATCH_SIZE = 1000;
        int DELAY_TICKS = 2;
        ((CompletableFuture)this.plugin.getProtectDatabase().countRestoreActions(timeArg, radiusArg, actionTypes).thenAccept(totalLogs -> {
            if (totalLogs == 0L) {
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noLogs");
                return;
            }
            if (!silent) {
                if (verbose) {
                    player.sendMessage(this.plugin.getLangManager().get("messages.rollback.start-verbose").replace("<total>", String.valueOf(totalLogs)).replace("<batch>", String.valueOf(1000)));
                } else {
                    player.sendMessage(this.plugin.getLangManager().get("messages.rollback.start").replace("<total>", String.valueOf(totalLogs)).replace("<batch>", String.valueOf(1000)));
                }
            }
            this.processBatchRestore(player, preview, verbose, silent, timeArg, radiusArg, actionTypes, 0, (long)totalLogs, 1000, 2);
        })).exceptionally(error -> {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.error");
            error.printStackTrace();
            return null;
        });
    }

    private void processBatchRestore(Player player, boolean preview, boolean verbose, boolean silent, TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes, int currentSkip, long totalLogs, int batchSize, int delayTicks) {
        if ((long)currentSkip >= totalLogs) {
            if (!silent) {
                player.sendMessage(this.plugin.getLangManager().get("messages.rollback.success").replace("<current>", String.valueOf(currentSkip)).replace("<total>", String.valueOf(totalLogs)));
            }
            return;
        }
        ((CompletableFuture)this.plugin.getProtectDatabase().getRestoreActions(timeArg, radiusArg, actionTypes, currentSkip, batchSize).thenAccept(callbackLookup -> {
            Map groupedLogs = (Map)callbackLookup.getLogs();
            int processedInBatch = groupedLogs.values().stream().mapToInt(Set::size).sum();
            if (processedInBatch > 0) {
                this.plugin.getStellarTaskHook(() -> {
                    if (preview) {
                        this.plugin.getRestoreManager().preview(player, groupedLogs, verbose, silent);
                    } else {
                        this.plugin.getRestoreManager().rollback((CommandSender)player, groupedLogs, verbose, silent);
                    }
                    int totalProcessed = currentSkip + processedInBatch;
                    double progress = (double)totalProcessed * 100.0 / (double)totalLogs;
                    if (!silent) {
                        if (preview) {
                            if (verbose) {
                                player.sendMessage(this.plugin.getLangManager().get("messages.rollback.preview-verbose").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                            } else {
                                player.sendMessage(this.plugin.getLangManager().get("messages.rollback.preview").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                            }
                        } else if (verbose) {
                            player.sendMessage(this.plugin.getLangManager().get("messages.rollback.progress-verbose").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                        } else {
                            player.sendMessage(this.plugin.getLangManager().get("messages.rollback.progress").replace("<progress>", String.valueOf(Math.round(progress))).replace("<now>", String.valueOf(totalProcessed)).replace("<total>", String.valueOf(totalLogs)));
                        }
                    }
                    this.plugin.getStellarTaskHook(() -> this.processBatchRestore(player, preview, verbose, silent, timeArg, radiusArg, actionTypes, currentSkip + batchSize, totalLogs, batchSize, delayTicks)).runTask(delayTicks);
                }).runTask();
            } else {
                player.sendMessage(this.plugin.getLangManager().get("messages.rollback.success").replace("<current>", String.valueOf(currentSkip)).replace("<total>", String.valueOf(totalLogs)));
            }
        })).exceptionally(error -> {
            player.sendMessage(this.plugin.getLangManager().get("messages.rollback.error").replace("<section>", String.valueOf(currentSkip / batchSize + 1)).replace("<error>", error.getMessage()));
            error.printStackTrace();
            return null;
        });
    }
}

