/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.database.entries.players;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.enums.DeathCause;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerDeathEntry
extends LogEntry {
    private final byte cause;
    private Map<Long, Integer> drops = new HashMap<Long, Integer>();

    public PlayerDeathEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.cause = jsonObject.get("c").getAsByte();
        if (jsonObject.has("d")) {
            JsonObject addedItemsObj = jsonObject.get("d").getAsJsonObject();
            for (Map.Entry entry : addedItemsObj.entrySet()) {
                String base64Key = (String)entry.getKey();
                int amount = ((JsonElement)entry.getValue()).getAsInt();
                this.drops.put(Long.parseLong(base64Key), amount);
            }
        }
    }

    public PlayerDeathEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.cause = jsonObject.get("c").getAsByte();
        if (jsonObject.has("d")) {
            JsonObject addedItemsObj = jsonObject.get("d").getAsJsonObject();
            for (Map.Entry entry : addedItemsObj.entrySet()) {
                String base64Key = (String)entry.getKey();
                int amount = ((JsonElement)entry.getValue()).getAsInt();
                this.drops.put(Long.parseLong(base64Key), amount);
            }
        }
    }

    public PlayerDeathEntry(long playerId, Location location, byte cause, Map<Long, Integer> drops) {
        super(playerId, ActionType.DEATH.getId(), location, System.currentTimeMillis());
        this.cause = cause;
        this.drops = drops;
    }

    @Override
    public String getDataString() {
        return DeathCause.getById(this.getCause()).name();
    }

    @Override
    public String toSaveJson() {
        if (this.drops.isEmpty()) {
            return "{\"c\":" + this.cause + "}";
        }
        JsonObject obj = new JsonObject();
        obj.addProperty("c", (Number)this.cause);
        JsonObject dropItemsOjb = new JsonObject();
        for (Map.Entry<Long, Integer> addedItem : this.getDrops().entrySet()) {
            dropItemsOjb.addProperty(String.valueOf(addedItem.getKey()), (Number)addedItem.getValue());
        }
        obj.add("d", (JsonElement)dropItemsOjb);
        return obj.toString();
    }

    @Generated
    public byte getCause() {
        return this.cause;
    }

    @Generated
    public Map<Long, Integer> getDrops() {
        return this.drops;
    }
}

