/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.jol.datamodel;

import io.github.insideranh.stellarprotect.libs.jol.datamodel.DataModel;
import java.util.Objects;

public class Model64
implements DataModel {
    private final int align;
    private final boolean compRefs;
    private final boolean compKlass;

    public Model64(boolean compressedRefs, boolean compressedClasses, int align) {
        this.compRefs = compressedRefs;
        this.compKlass = compressedClasses;
        this.align = align;
    }

    public Model64(boolean compressedRefs, boolean compressedClasses) {
        this(compressedRefs, compressedClasses, 8);
    }

    @Override
    public int markHeaderSize() {
        return 8;
    }

    @Override
    public int classHeaderSize() {
        return this.compKlass ? 4 : 8;
    }

    @Override
    public int arrayLengthHeaderSize() {
        return 4;
    }

    @Override
    public int headerSize() {
        return this.markHeaderSize() + this.classHeaderSize();
    }

    @Override
    public int arrayHeaderSize() {
        return this.headerSize() + this.arrayLengthHeaderSize();
    }

    @Override
    public int sizeOf(String klass) {
        switch (klass) {
            case "byte": 
            case "boolean": {
                return 1;
            }
            case "short": 
            case "char": {
                return 2;
            }
            case "int": 
            case "float": {
                return 4;
            }
            case "long": 
            case "double": {
                return 8;
            }
        }
        return this.compRefs ? 4 : 8;
    }

    @Override
    public int objectAlignment() {
        return this.align;
    }

    public String toString() {
        return "64-bit model, " + (this.compRefs ? "" : "NO ") + "compressed references, " + (this.compKlass ? "" : "NO ") + "compressed classes, " + this.align + "-byte aligned";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Model64 model64 = (Model64)o;
        return this.align == model64.align;
    }

    public int hashCode() {
        return Objects.hash(this.align);
    }
}

