/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client;

import io.github.insideranh.stellarprotect.libs.mongodb.ConnectionString;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoClientSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoDriverInformation;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.MongoClient;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.Clusters;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.MongoClientImpl;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Cluster;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ServerAddressHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactoryFactory;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.StreamFactoryHelper;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

public final class MongoClients {
    public static MongoClient create() {
        return MongoClients.create(new ConnectionString("mongodb://localhost"));
    }

    public static MongoClient create(MongoClientSettings settings) {
        return MongoClients.create(settings, null);
    }

    public static MongoClient create(String connectionString) {
        return MongoClients.create(new ConnectionString(connectionString));
    }

    public static MongoClient create(ConnectionString connectionString) {
        return MongoClients.create(connectionString, null);
    }

    public static MongoClient create(ConnectionString connectionString, @Nullable MongoDriverInformation mongoDriverInformation) {
        return MongoClients.create(MongoClientSettings.builder().applyConnectionString(connectionString).build(), mongoDriverInformation);
    }

    public static MongoClient create(MongoClientSettings settings, @Nullable MongoDriverInformation mongoDriverInformation) {
        Assertions.notNull("settings", settings);
        MongoDriverInformation.Builder builder = mongoDriverInformation == null ? MongoDriverInformation.builder() : MongoDriverInformation.builder(mongoDriverInformation);
        MongoDriverInformation driverInfo = builder.driverName("sync").build();
        StreamFactoryFactory syncStreamFactoryFactory = StreamFactoryHelper.getSyncStreamFactoryFactory(settings.getTransportSettings(), ServerAddressHelper.getInetAddressResolver(settings));
        Cluster cluster = Clusters.createCluster(settings, driverInfo, syncStreamFactoryFactory);
        return new MongoClientImpl(cluster, settings, driverInfo, syncStreamFactoryFactory);
    }

    private MongoClients() {
    }
}

