/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.client.internal;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonString;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.Document;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.mongodb.ExplainVerbosity;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoNamespace;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadConcern;
import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.client.ListSearchIndexesIterable;
import io.github.insideranh.stellarprotect.libs.mongodb.client.cursor.TimeoutMode;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.MongoIterableImpl;
import io.github.insideranh.stellarprotect.libs.mongodb.client.internal.OperationExecutor;
import io.github.insideranh.stellarprotect.libs.mongodb.client.model.Collation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutSettings;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.BatchCursor;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ExplainableReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.ReadOperation;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.operation.SyncOperations;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

final class ListSearchIndexesIterableImpl<TResult>
extends MongoIterableImpl<TResult>
implements ListSearchIndexesIterable<TResult> {
    private final SyncOperations<BsonDocument> operations;
    private final Class<TResult> resultClass;
    @Nullable
    private Boolean allowDiskUse;
    @Nullable
    private long maxTimeMS;
    @Nullable
    private Collation collation;
    @Nullable
    private BsonValue comment;
    @Nullable
    private String indexName;
    private final CodecRegistry codecRegistry;

    ListSearchIndexesIterableImpl(MongoNamespace namespace, OperationExecutor executor, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, boolean retryReads, TimeoutSettings timeoutSettings) {
        super(null, executor, ReadConcern.DEFAULT, readPreference, retryReads, timeoutSettings);
        this.resultClass = resultClass;
        this.operations = new SyncOperations<BsonDocument>(namespace, BsonDocument.class, readPreference, codecRegistry, retryReads, timeoutSettings);
        this.codecRegistry = codecRegistry;
    }

    @Override
    public ReadOperation<BatchCursor<TResult>> asReadOperation() {
        return this.asAggregateOperation();
    }

    @Override
    public ListSearchIndexesIterable<TResult> allowDiskUse(@Nullable Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> timeoutMode(TimeoutMode timeoutMode) {
        super.timeoutMode(timeoutMode);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> collation(@Nullable Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> comment(@Nullable String comment) {
        this.comment = comment == null ? null : new BsonString(comment);
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> comment(@Nullable BsonValue comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public ListSearchIndexesIterable<TResult> name(String indexName) {
        this.indexName = Assertions.notNull("indexName", indexName);
        return this;
    }

    @Override
    public Document explain() {
        return this.executeExplain(Document.class, null);
    }

    @Override
    public Document explain(ExplainVerbosity verbosity) {
        Assertions.notNull("verbosity", verbosity);
        return this.executeExplain(Document.class, verbosity);
    }

    @Override
    public <E> E explain(Class<E> explainResultClass) {
        Assertions.notNull("explainResultClass", explainResultClass);
        return this.executeExplain(explainResultClass, null);
    }

    @Override
    public <E> E explain(Class<E> explainResultClass, ExplainVerbosity verbosity) {
        Assertions.notNull("explainResultClass", explainResultClass);
        Assertions.notNull("verbosity", verbosity);
        return this.executeExplain(explainResultClass, verbosity);
    }

    private <E> E executeExplain(Class<E> explainResultClass, @Nullable ExplainVerbosity verbosity) {
        return this.getExecutor().execute(this.asAggregateOperation().asExplainableOperation(verbosity, this.codecRegistry.get(explainResultClass)), this.getReadPreference(), this.getReadConcern(), this.getClientSession());
    }

    private ExplainableReadOperation<BatchCursor<TResult>> asAggregateOperation() {
        return this.operations.listSearchIndexes(this.resultClass, this.indexName, this.getBatchSize(), this.collation, this.comment, this.allowDiskUse);
    }

    @Override
    protected OperationExecutor getExecutor() {
        return this.getExecutor(this.operations.createTimeoutSettings(this.maxTimeMS));
    }
}

