/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.event;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.mongodb.RequestContext;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ConnectionDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.event.CommandEvent;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class CommandSucceededEvent
extends CommandEvent {
    private final BsonDocument response;
    private final long elapsedTimeNanos;

    public CommandSucceededEvent(@Nullable RequestContext requestContext, long operationId, int requestId, ConnectionDescription connectionDescription, String databaseName, String commandName, BsonDocument response, long elapsedTimeNanos) {
        super(requestContext, operationId, requestId, connectionDescription, databaseName, commandName);
        this.response = response;
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public BsonDocument getResponse() {
        return this.response;
    }
}

