/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.async;

import io.github.insideranh.stellarprotect.libs.mongodb.internal.TimeoutContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncConsumer;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncFunction;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.AsyncSupplier;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.SingleResultCallback;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function.AsyncCallbackLoop;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function.LoopState;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function.RetryState;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.async.function.RetryingAsyncCallbackSupplier;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;

@FunctionalInterface
public interface AsyncRunnable
extends AsyncSupplier<Void>,
AsyncConsumer<Void> {
    public static AsyncRunnable beginAsync() {
        return c -> c.complete(c);
    }

    default public AsyncRunnable thenRun(AsyncRunnable runnable) {
        return c -> this.unsafeFinish((r, e) -> {
            if (e == null) {
                runnable.finish(c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public <T extends Throwable> AsyncRunnable thenRunTryCatchAsyncBlocks(AsyncRunnable runnable, Class<T> exceptionClass, AsyncFunction<Throwable, Void> errorFunction) {
        return this.thenRunTryCatchAsyncBlocks(runnable, (Throwable e) -> exceptionClass.isInstance(e), errorFunction);
    }

    default public AsyncRunnable thenRunTryCatchAsyncBlocks(AsyncRunnable runnable, Predicate<Throwable> errorCheck, AsyncFunction<Throwable, Void> errorFunction) {
        return this.thenRun(c -> AsyncRunnable.beginAsync().thenRun(runnable).onErrorIf(errorCheck, errorFunction).finish(c));
    }

    default public AsyncRunnable thenRunIf(Supplier<Boolean> condition, AsyncRunnable runnable) {
        return callback -> this.unsafeFinish((arg_0, arg_1) -> AsyncRunnable.lambda$thenRunIf$5(callback, (Supplier)condition, runnable, arg_0, arg_1));
    }

    default public <R> AsyncSupplier<R> thenSupply(AsyncSupplier<R> supplier) {
        return c -> this.unsafeFinish((r, e) -> {
            if (e == null) {
                supplier.finish(c);
            } else {
                c.completeExceptionally(e);
            }
        });
    }

    default public AsyncRunnable thenRunRetryingWhile(TimeoutContext timeoutContext, AsyncRunnable runnable, Predicate<Throwable> shouldRetry) {
        return this.thenRun(callback -> new RetryingAsyncCallbackSupplier(new RetryState(timeoutContext), (rs, lastAttemptFailure) -> shouldRetry.test((Throwable)lastAttemptFailure), cb -> runnable.finish(cb)).get(callback));
    }

    default public AsyncRunnable thenRunDoWhileLoop(AsyncRunnable loopBodyRunnable, BooleanSupplier whileCheck) {
        return this.thenRun(finalCallback -> {
            LoopState loopState = new LoopState();
            new AsyncCallbackLoop(loopState, iterationCallback -> loopBodyRunnable.finish((result, t) -> {
                if (t != null) {
                    iterationCallback.completeExceptionally(t);
                    return;
                }
                if (loopState.breakAndCompleteIf(() -> !whileCheck.getAsBoolean(), iterationCallback)) {
                    return;
                }
                iterationCallback.complete(iterationCallback);
            })).run(finalCallback);
        });
    }

    private static /* synthetic */ void lambda$thenRunIf$5(SingleResultCallback callback, Supplier condition, AsyncRunnable runnable, Void r, Throwable e) {
        boolean matched;
        if (e != null) {
            callback.completeExceptionally(e);
            return;
        }
        try {
            matched = (Boolean)condition.get();
        }
        catch (Throwable t) {
            callback.completeExceptionally(t);
            return;
        }
        if (matched) {
            runnable.finish(callback);
        } else {
            callback.complete(callback);
        }
    }
}

