/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.async;

import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.AsyncCompletionHandler;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;

public interface SingleResultCallback<T> {
    public void onResult(@Nullable T var1, @Nullable Throwable var2);

    default public AsyncCompletionHandler<T> asHandler() {
        return new AsyncCompletionHandler<T>(){

            @Override
            public void completed(@Nullable T result) {
                SingleResultCallback.this.onResult(result, null);
            }

            @Override
            public void failed(Throwable t) {
                SingleResultCallback.this.completeExceptionally(t);
            }
        };
    }

    default public void complete(SingleResultCallback<Void> callback) {
        Assertions.assertTrue(callback == this);
        this.onResult(null, null);
    }

    default public void complete(@Nullable T result) {
        this.onResult(result, null);
    }

    default public void completeExceptionally(Throwable t) {
        this.onResult(null, Assertions.assertNotNull(t));
    }
}

