/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.binding;

import io.github.insideranh.stellarprotect.libs.mongodb.ReadPreference;
import io.github.insideranh.stellarprotect.libs.mongodb.ServerAddress;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.connection.ServerDescription;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.AbstractReferenceCounted;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ConnectionSource;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.binding.ReadWriteBinding;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Cluster;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.Connection;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OperationContext;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.ServerTuple;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.selector.ServerAddressSelector;

public class SingleServerBinding
extends AbstractReferenceCounted
implements ReadWriteBinding {
    private final Cluster cluster;
    private final ServerAddress serverAddress;
    private final OperationContext operationContext;

    public SingleServerBinding(Cluster cluster, ServerAddress serverAddress, OperationContext operationContext) {
        this.cluster = Assertions.notNull("cluster", cluster);
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
        this.operationContext = Assertions.notNull("operationContext", operationContext);
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new SingleServerBindingConnectionSource();
    }

    @Override
    public ReadPreference getReadPreference() {
        return ReadPreference.primary();
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new SingleServerBindingConnectionSource();
    }

    @Override
    public ConnectionSource getReadConnectionSource(int minWireVersion, ReadPreference fallbackReadPreference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OperationContext getOperationContext() {
        return this.operationContext;
    }

    @Override
    public SingleServerBinding retain() {
        super.retain();
        return this;
    }

    private final class SingleServerBindingConnectionSource
    extends AbstractReferenceCounted
    implements ConnectionSource {
        private final ServerDescription serverDescription;

        private SingleServerBindingConnectionSource() {
            SingleServerBinding.this.retain();
            ServerTuple serverTuple = SingleServerBinding.this.cluster.selectServer(new ServerAddressSelector(SingleServerBinding.this.serverAddress), SingleServerBinding.this.operationContext);
            this.serverDescription = serverTuple.getServerDescription();
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.serverDescription;
        }

        @Override
        public OperationContext getOperationContext() {
            return SingleServerBinding.this.operationContext;
        }

        @Override
        public ReadPreference getReadPreference() {
            return ReadPreference.primary();
        }

        @Override
        public Connection getConnection() {
            return SingleServerBinding.this.cluster.selectServer(new ServerAddressSelector(SingleServerBinding.this.serverAddress), SingleServerBinding.this.operationContext).getServer().getConnection(SingleServerBinding.this.operationContext);
        }

        @Override
        public ConnectionSource retain() {
            super.retain();
            return this;
        }

        @Override
        public int release() {
            int count = super.release();
            if (count == 0) {
                SingleServerBinding.this.release();
            }
            return count;
        }
    }
}

