/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.ByteBuf;
import io.github.insideranh.stellarprotect.libs.mongodb.MongoInternalException;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.CompressedHeader;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MessageHeader;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.OpCode;

public final class ReplyHeader {
    public static final int REPLY_HEADER_LENGTH = 20;
    public static final int TOTAL_REPLY_HEADER_LENGTH = 36;
    private final int messageLength;
    private final int requestId;
    private final int responseTo;
    private final boolean hasMoreToCome;

    ReplyHeader(ByteBuf header, MessageHeader messageHeader) {
        this(messageHeader.getMessageLength(), messageHeader.getOpCode(), messageHeader, header);
    }

    ReplyHeader(ByteBuf header, CompressedHeader compressedHeader) {
        this(compressedHeader.getUncompressedSize() + 16, compressedHeader.getOriginalOpcode(), compressedHeader.getMessageHeader(), header);
    }

    private ReplyHeader(int messageLength, int opCode, MessageHeader messageHeader, ByteBuf header) {
        this.messageLength = messageLength;
        this.requestId = messageHeader.getRequestId();
        this.responseTo = messageHeader.getResponseTo();
        if (opCode == OpCode.OP_MSG.getValue()) {
            int flagBits = header.getInt();
            this.hasMoreToCome = (flagBits & 2) != 0;
            header.get();
        } else if (opCode == OpCode.OP_REPLY.getValue()) {
            if (messageLength < 36) {
                throw new MongoInternalException(String.format("The reply message length %d is less than the minimum message length %d", messageLength, 36));
            }
            this.hasMoreToCome = false;
            header.getInt();
            header.getLong();
            header.getInt();
            int numberReturned = header.getInt();
            if (numberReturned != 1) {
                throw new MongoInternalException(String.format("The reply message number of returned documents, %d, is expected to be 1", numberReturned));
            }
        } else {
            throw new MongoInternalException(String.format("Unexpected reply message opCode %d", opCode));
        }
    }

    public int getMessageLength() {
        return this.messageLength;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public int getResponseTo() {
        return this.responseTo;
    }

    public boolean hasMoreToCome() {
        return this.hasMoreToCome;
    }
}

