/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.connection;

import io.github.insideranh.stellarprotect.libs.bson.BsonDocument;
import io.github.insideranh.stellarprotect.libs.bson.BsonDocumentWrapper;
import io.github.insideranh.stellarprotect.libs.bson.BsonObjectId;
import io.github.insideranh.stellarprotect.libs.bson.BsonValue;
import io.github.insideranh.stellarprotect.libs.bson.BsonWriter;
import io.github.insideranh.stellarprotect.libs.bson.FieldNameValidator;
import io.github.insideranh.stellarprotect.libs.bson.codecs.BsonValueCodecProvider;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Codec;
import io.github.insideranh.stellarprotect.libs.bson.codecs.Encoder;
import io.github.insideranh.stellarprotect.libs.bson.codecs.EncoderContext;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistries;
import io.github.insideranh.stellarprotect.libs.bson.codecs.configuration.CodecRegistry;
import io.github.insideranh.stellarprotect.libs.mongodb.assertions.Assertions;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.DeleteRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.InsertRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.UpdateRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.WriteRequest;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.bulk.WriteRequestWithIndex;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.FieldTrackingBsonWriter;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.IdHoldingBsonWriter;
import io.github.insideranh.stellarprotect.libs.mongodb.internal.connection.MessageSequences;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class SplittablePayload
extends MessageSequences {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private final FieldNameValidator fieldNameValidator;
    private final WriteRequestEncoder writeRequestEncoder = new WriteRequestEncoder();
    private final Type payloadType;
    private final List<WriteRequestWithIndex> writeRequestWithIndexes;
    private final boolean ordered;
    private final Map<Integer, BsonValue> insertedIds = new HashMap<Integer, BsonValue>();
    private int position = 0;

    public SplittablePayload(Type payloadType, List<WriteRequestWithIndex> writeRequestWithIndexes, boolean ordered, FieldNameValidator fieldNameValidator) {
        this.payloadType = Assertions.notNull("batchType", payloadType);
        this.writeRequestWithIndexes = Assertions.notNull("writeRequests", writeRequestWithIndexes);
        this.ordered = ordered;
        this.fieldNameValidator = Assertions.notNull("fieldNameValidator", fieldNameValidator);
    }

    public FieldNameValidator getFieldNameValidator() {
        return this.fieldNameValidator;
    }

    public Type getPayloadType() {
        return this.payloadType;
    }

    public String getPayloadName() {
        if (this.payloadType == Type.INSERT) {
            return "documents";
        }
        if (this.payloadType == Type.UPDATE || this.payloadType == Type.REPLACE) {
            return "updates";
        }
        return "deletes";
    }

    boolean hasPayload() {
        return !this.writeRequestWithIndexes.isEmpty();
    }

    public int size() {
        return this.writeRequestWithIndexes.size();
    }

    public Map<Integer, BsonValue> getInsertedIds() {
        return this.insertedIds;
    }

    public List<BsonDocument> getPayload() {
        return this.writeRequestWithIndexes.stream().map(wri -> new BsonDocumentWrapper<WriteRequestWithIndex>((WriteRequestWithIndex)wri, this.writeRequestEncoder)).collect(Collectors.toList());
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public boolean hasAnotherSplit() {
        Assertions.assertTrue(this.position > 0);
        return this.writeRequestWithIndexes.size() > this.position;
    }

    boolean isOrdered() {
        return this.ordered;
    }

    public SplittablePayload getNextSplit() {
        Assertions.isTrue("hasAnotherSplit", this.hasAnotherSplit());
        List<WriteRequestWithIndex> nextPayLoad = this.writeRequestWithIndexes.subList(this.position, this.writeRequestWithIndexes.size());
        return new SplittablePayload(this.payloadType, nextPayLoad, this.ordered, this.fieldNameValidator);
    }

    public boolean isEmpty() {
        return this.writeRequestWithIndexes.isEmpty();
    }

    private static Codec<BsonDocument> getCodec(BsonDocument document) {
        return REGISTRY.get(document.getClass());
    }

    class WriteRequestEncoder
    implements Encoder<WriteRequestWithIndex> {
        WriteRequestEncoder() {
        }

        @Override
        public void encode(BsonWriter writer, WriteRequestWithIndex writeRequestWithIndex, EncoderContext encoderContext) {
            if (writeRequestWithIndex.getType() == WriteRequest.Type.INSERT) {
                InsertRequest insertRequest = (InsertRequest)writeRequestWithIndex.getWriteRequest();
                BsonDocument document = insertRequest.getDocument();
                BsonValue documentId = SplittablePayload.this.insertedIds.compute(writeRequestWithIndex.getIndex(), (writeRequestIndex, writeRequestDocumentId) -> {
                    IdHoldingBsonWriter idHoldingBsonWriter = new IdHoldingBsonWriter(writer, writeRequestDocumentId instanceof BsonObjectId ? writeRequestDocumentId.asObjectId() : null);
                    SplittablePayload.getCodec(document).encode(idHoldingBsonWriter, document, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
                    return idHoldingBsonWriter.getId();
                });
                if (documentId == null) {
                    SplittablePayload.this.insertedIds.put(writeRequestWithIndex.getIndex(), null);
                }
            } else if (writeRequestWithIndex.getType() == WriteRequest.Type.UPDATE || writeRequestWithIndex.getType() == WriteRequest.Type.REPLACE) {
                UpdateRequest update = (UpdateRequest)writeRequestWithIndex.getWriteRequest();
                writer.writeStartDocument();
                writer.writeName("q");
                SplittablePayload.getCodec(update.getFilter()).encode(writer, update.getFilter(), EncoderContext.builder().build());
                BsonValue updateValue = update.getUpdateValue();
                if (!updateValue.isDocument() && !updateValue.isArray()) {
                    throw new IllegalArgumentException("Invalid BSON value for an update.");
                }
                if (updateValue.isArray() && updateValue.asArray().isEmpty()) {
                    throw new IllegalArgumentException("Invalid pipeline for an update. The pipeline may not be empty.");
                }
                writer.writeName("u");
                if (updateValue.isDocument()) {
                    FieldTrackingBsonWriter fieldTrackingBsonWriter = new FieldTrackingBsonWriter(writer);
                    SplittablePayload.getCodec(updateValue.asDocument()).encode(fieldTrackingBsonWriter, updateValue.asDocument(), EncoderContext.builder().build());
                    if (writeRequestWithIndex.getType() == WriteRequest.Type.UPDATE && !fieldTrackingBsonWriter.hasWrittenField()) {
                        throw new IllegalArgumentException("Invalid BSON document for an update. The document may not be empty.");
                    }
                } else if (update.getType() == WriteRequest.Type.UPDATE && updateValue.isArray()) {
                    writer.writeStartArray();
                    for (BsonValue bsonValue : updateValue.asArray()) {
                        SplittablePayload.getCodec(bsonValue.asDocument()).encode(writer, bsonValue.asDocument(), EncoderContext.builder().build());
                    }
                    writer.writeEndArray();
                }
                if (update.isMulti()) {
                    writer.writeBoolean("multi", true);
                }
                if (update.isUpsert()) {
                    writer.writeBoolean("upsert", true);
                }
                if (update.getCollation() != null) {
                    writer.writeName("collation");
                    BsonDocument collation = Assertions.assertNotNull(update.getCollation()).asDocument();
                    SplittablePayload.getCodec(collation).encode(writer, collation, EncoderContext.builder().build());
                }
                if (update.getArrayFilters() != null) {
                    writer.writeStartArray("arrayFilters");
                    for (BsonDocument bsonDocument : Assertions.assertNotNull(update.getArrayFilters())) {
                        SplittablePayload.getCodec(bsonDocument).encode(writer, bsonDocument, EncoderContext.builder().build());
                    }
                    writer.writeEndArray();
                }
                if (update.getHint() != null) {
                    writer.writeName("hint");
                    SplittablePayload.getCodec(Assertions.assertNotNull(update.getHint())).encode(writer, Assertions.assertNotNull(update.getHint()), EncoderContext.builder().build());
                } else if (update.getHintString() != null) {
                    writer.writeString("hint", update.getHintString());
                }
                if (update.getSort() != null) {
                    writer.writeName("sort");
                    SplittablePayload.getCodec(Assertions.assertNotNull(update.getSort())).encode(writer, Assertions.assertNotNull(update.getSort()), EncoderContext.builder().build());
                }
                writer.writeEndDocument();
            } else {
                DeleteRequest deleteRequest = (DeleteRequest)writeRequestWithIndex.getWriteRequest();
                writer.writeStartDocument();
                writer.writeName("q");
                SplittablePayload.getCodec(deleteRequest.getFilter()).encode(writer, deleteRequest.getFilter(), EncoderContext.builder().build());
                writer.writeInt32("limit", deleteRequest.isMulti() ? 0 : 1);
                if (deleteRequest.getCollation() != null) {
                    writer.writeName("collation");
                    BsonDocument collation = Assertions.assertNotNull(deleteRequest.getCollation()).asDocument();
                    SplittablePayload.getCodec(collation).encode(writer, collation, EncoderContext.builder().build());
                }
                if (deleteRequest.getHint() != null) {
                    writer.writeName("hint");
                    BsonDocument hint = Assertions.assertNotNull(deleteRequest.getHint());
                    SplittablePayload.getCodec(hint).encode(writer, hint, EncoderContext.builder().build());
                } else if (deleteRequest.getHintString() != null) {
                    writer.writeString("hint", deleteRequest.getHintString());
                }
                writer.writeEndDocument();
            }
        }

        @Override
        public Class<WriteRequestWithIndex> getEncoderClass() {
            return WriteRequestWithIndex.class;
        }
    }

    public static enum Type {
        INSERT,
        UPDATE,
        REPLACE,
        DELETE;

    }
}

