/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.libs.mongodb.internal.thread;

import io.github.insideranh.stellarprotect.libs.mongodb.MongoInterruptedException;
import io.github.insideranh.stellarprotect.libs.mongodb.lang.Nullable;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Optional;

public final class InterruptionUtil {
    public static MongoInterruptedException interruptAndCreateMongoInterruptedException(@Nullable String msg, @Nullable InterruptedException cause) {
        Thread.currentThread().interrupt();
        return new MongoInterruptedException(msg, cause);
    }

    public static Optional<MongoInterruptedException> translateInterruptedException(@Nullable Throwable e, @Nullable String message) {
        if (e instanceof InterruptedException) {
            return Optional.of(InterruptionUtil.interruptAndCreateMongoInterruptedException(message, (InterruptedException)e));
        }
        if (e instanceof InterruptedIOException && !(e instanceof SocketTimeoutException) || e instanceof ClosedByInterruptException || e instanceof SocketException && Thread.currentThread().isInterrupted()) {
            return Optional.of(new MongoInterruptedException(message, (Exception)e));
        }
        return Optional.empty();
    }

    private InterruptionUtil() {
    }
}

