/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.managers;

import com.google.gson.Gson;
import io.github.insideranh.stellarprotect.StellarProtect;
import io.github.insideranh.stellarprotect.cache.keys.LocationCache;
import io.github.insideranh.stellarprotect.database.entries.LogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerBlockStateLogEntry;
import io.github.insideranh.stellarprotect.database.entries.players.PlayerKillLogEntry;
import io.github.insideranh.stellarprotect.entities.DataEntity;
import io.github.insideranh.stellarprotect.enums.ActionType;
import io.github.insideranh.stellarprotect.restore.BlockRestore;
import io.github.insideranh.stellarprotect.utils.PlayerUtils;
import io.github.insideranh.stellarprotect.utils.SerializerUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public class RestoreManager {
    private final StellarProtect plugin = StellarProtect.getInstance();

    public void preview(Player sender, Map<LocationCache, Set<LogEntry>> groupedLogs, boolean verbose, boolean silent) {
        Gson gson = SerializerUtils.getGson();
        int processedCount = 0;
        int MAX_PER_TICK = 50;
        block2: for (Map.Entry<LocationCache, Set<LogEntry>> entry : groupedLogs.entrySet()) {
            for (LogEntry logEntry : entry.getValue()) {
                if (logEntry instanceof PlayerBlockLogEntry) {
                    PlayerBlockLogEntry blockLogEntry = (PlayerBlockLogEntry)logEntry;
                    Location location = blockLogEntry.asBukkitLocation();
                    if (verbose) {
                        String actionName = blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId() ? "PLACE" : "BREAK";
                        sender.sendMessage("\u00a77[VERBOSE] \u00a7e" + actionName + " \u00a77at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77by \u00a7f" + PlayerUtils.getNameOfEntity(blockLogEntry.getPlayerId()) + " \u00a77(ID: " + blockLogEntry.getPlayerId() + ") \u00a77at \u00a7f" + new SimpleDateFormat("HH:mm:ss dd/MM/yyyy").format(new Date(blockLogEntry.getCreatedAt())));
                    }
                    BlockRestore blockRestore = this.plugin.getBlockRestore(blockLogEntry.getDataString());
                    if (blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId()) {
                        if (!silent) {
                            this.plugin.getStellarTaskHook(() -> blockRestore.previewRemove(sender, location)).runTask(location);
                        }
                    } else if (blockLogEntry.getActionType() == ActionType.BLOCK_BREAK.getId() && !silent) {
                        this.plugin.getStellarTaskHook(() -> blockRestore.preview(sender, gson, location)).runTask(location);
                    }
                } else if (logEntry instanceof PlayerBlockStateLogEntry) {
                    PlayerBlockStateLogEntry blockStateLogEntry = (PlayerBlockStateLogEntry)logEntry;
                    BlockRestore blockRestore = this.plugin.getBlockRestore(blockStateLogEntry.lastDataString());
                    Location location = blockStateLogEntry.asBukkitLocation();
                    if (verbose) {
                        sender.sendMessage("\u00a77[VERBOSE] \u00a7eSTATE_CHANGE \u00a77at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77by \u00a7f" + PlayerUtils.getNameOfEntity(logEntry.getPlayerId()) + " \u00a77(ID: " + blockStateLogEntry.getPlayerId() + ") \u00a77at \u00a7f" + new SimpleDateFormat("HH:mm:ss dd/MM/yyyy").format(new Date(blockStateLogEntry.getCreatedAt())));
                    }
                    if (!silent) {
                        this.plugin.getStellarTaskHook(() -> blockRestore.preview(sender, gson, location)).runTask(location);
                    }
                }
                if (++processedCount % 50 != 0) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue block2;
                }
            }
        }
    }

    public void rollback(CommandSender sender, Map<LocationCache, Set<LogEntry>> groupedLogs, boolean verbose, boolean silent) {
        int processedCount = 0;
        int MAX_PER_TICK = 50;
        block2: for (Map.Entry<LocationCache, Set<LogEntry>> entry : groupedLogs.entrySet()) {
            for (LogEntry logEntry : entry.getValue()) {
                this.restore(logEntry, sender, verbose);
                if (++processedCount % 50 != 0) continue;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    continue block2;
                }
            }
        }
    }

    public void restore(LogEntry logEntry, CommandSender sender, boolean verbose) {
        Gson gson = SerializerUtils.getGson();
        if (logEntry instanceof PlayerBlockLogEntry) {
            PlayerBlockLogEntry blockLogEntry = (PlayerBlockLogEntry)logEntry;
            Location location = blockLogEntry.asBukkitLocation();
            if (verbose) {
                String actionName = blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId() ? "REMOVING" : "RESTORING";
                sender.sendMessage("\u00a77[VERBOSE] \u00a7c" + actionName + " \u00a77block at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77(originally by \u00a7f" + PlayerUtils.getNameOfEntity(logEntry.getPlayerId()) + " \u00a77ID: " + blockLogEntry.getPlayerId() + "\u00a77) \u00a77data: \u00a7f" + blockLogEntry.getDataString());
            }
            BlockRestore blockRestore = this.plugin.getBlockRestore(blockLogEntry.getDataString());
            if (blockLogEntry.getActionType() == ActionType.BLOCK_PLACE.getId()) {
                this.plugin.getStellarTaskHook(() -> blockRestore.remove(location)).runTask(location);
            } else if (blockLogEntry.getActionType() == ActionType.BLOCK_BREAK.getId()) {
                this.plugin.getStellarTaskHook(() -> blockRestore.reset(gson, location)).runTask(location);
            }
        } else if (logEntry instanceof PlayerBlockStateLogEntry) {
            PlayerBlockStateLogEntry blockStateLogEntry = (PlayerBlockStateLogEntry)logEntry;
            BlockRestore blockRestore = this.plugin.getBlockRestore(blockStateLogEntry.lastDataString());
            Location location = blockStateLogEntry.asBukkitLocation();
            if (verbose) {
                sender.sendMessage("\u00a77[VERBOSE] \u00a7cREVERTING \u00a77state at \u00a7f" + (int)location.getX() + ", " + (int)location.getY() + ", " + (int)location.getZ() + " \u00a77in \u00a7f" + location.getWorld().getName() + " \u00a77(originally by \u00a7f" + PlayerUtils.getNameOfEntity(logEntry.getPlayerId()) + " \u00a77ID: " + blockStateLogEntry.getPlayerId() + "\u00a77) \u00a77data: \u00a7f" + blockStateLogEntry.lastDataString());
            }
            this.plugin.getStellarTaskHook(() -> blockRestore.reset(gson, location)).runTask(location);
        } else if (logEntry instanceof PlayerKillLogEntry) {
            PlayerKillLogEntry playerKillLogEntry = (PlayerKillLogEntry)logEntry;
            if (playerKillLogEntry.getEntityType().equals("PLAYER")) {
                return;
            }
            EntityType entityType = EntityType.valueOf((String)playerKillLogEntry.getEntityType());
            Location location = playerKillLogEntry.asBukkitLocation();
            Entity entity = location.getWorld().spawnEntity(location, entityType);
            DataEntity dataEntity = this.plugin.getDataEntity(playerKillLogEntry.getEntityData().getEntityData());
            dataEntity.applyToEntity(entity);
        }
    }
}

