/*
 * Decompiled with CFR 0.152.
 */
package io.github.insideranh.stellarprotect.maps;

import java.util.Arrays;

public final class IntObjectMap<V> {
    private static final int DEFAULT_CAPACITY = 16;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int EMPTY_KEY = Integer.MIN_VALUE;
    private int[] keys;
    private Object[] values;
    private int size;
    private int threshold;
    private int mask;

    public IntObjectMap(int initialCapacity) {
        int capacity = Integer.highestOneBit(initialCapacity - 1) << 1;
        if (capacity < 16) {
            capacity = 16;
        }
        this.keys = new int[capacity];
        this.values = new Object[capacity];
        this.mask = capacity - 1;
        this.threshold = (int)((float)capacity * 0.75f);
        Arrays.fill(this.keys, Integer.MIN_VALUE);
    }

    private static int hash(int key) {
        key ^= key >>> 16;
        key *= 73244475;
        key ^= key >>> 16;
        return key;
    }

    public V get(int key) {
        if (key == Integer.MIN_VALUE) {
            key = 0;
        }
        int idx = IntObjectMap.hash(key) & this.mask;
        while (this.keys[idx] != Integer.MIN_VALUE) {
            if (this.keys[idx] == key) {
                return (V)this.values[idx];
            }
            idx = idx + 1 & this.mask;
        }
        return null;
    }

    public V put(int key, V value) {
        if (key == Integer.MIN_VALUE) {
            key = 0;
        }
        if (this.size >= this.threshold) {
            this.resize();
        }
        int idx = IntObjectMap.hash(key) & this.mask;
        while (this.keys[idx] != Integer.MIN_VALUE) {
            if (this.keys[idx] == key) {
                Object oldValue = this.values[idx];
                this.values[idx] = value;
                return (V)oldValue;
            }
            idx = idx + 1 & this.mask;
        }
        this.keys[idx] = key;
        this.values[idx] = value;
        ++this.size;
        return null;
    }

    public V remove(int key) {
        if (key == Integer.MIN_VALUE) {
            key = 0;
        }
        int idx = IntObjectMap.hash(key) & this.mask;
        while (this.keys[idx] != Integer.MIN_VALUE) {
            if (this.keys[idx] == key) {
                Object oldValue = this.values[idx];
                int nextIdx = idx + 1 & this.mask;
                while (this.keys[nextIdx] != Integer.MIN_VALUE) {
                    int rehashIdx = IntObjectMap.hash(this.keys[nextIdx]) & this.mask;
                    if (nextIdx > idx && (rehashIdx <= idx || rehashIdx > nextIdx) || nextIdx < idx && rehashIdx <= idx && rehashIdx > nextIdx) {
                        this.keys[idx] = this.keys[nextIdx];
                        this.values[idx] = this.values[nextIdx];
                        idx = nextIdx;
                    }
                    nextIdx = nextIdx + 1 & this.mask;
                }
                this.keys[idx] = Integer.MIN_VALUE;
                this.values[idx] = null;
                --this.size;
                return (V)oldValue;
            }
            idx = idx + 1 & this.mask;
        }
        return null;
    }

    private void resize() {
        int[] oldKeys = this.keys;
        Object[] oldValues = this.values;
        int oldCapacity = this.keys.length;
        int newCapacity = oldCapacity << 1;
        this.keys = new int[newCapacity];
        this.values = new Object[newCapacity];
        Arrays.fill(this.keys, Integer.MIN_VALUE);
        this.mask = newCapacity - 1;
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.size = 0;
        for (int i = 0; i < oldCapacity; ++i) {
            if (oldKeys[i] == Integer.MIN_VALUE) continue;
            this.put(oldKeys[i], oldValues[i]);
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        Arrays.fill(this.keys, Integer.MIN_VALUE);
        Arrays.fill(this.values, null);
        this.size = 0;
    }
}

