/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.DatabaseFilters;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.arguments.UsersArg;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.items.ItemLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerBlockLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerTransactionEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionCategory;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class LoggerCache {
    private static final StellarProtect plugin = StellarProtect.getInstance();
    private static final Map<ActionCategory, CacheConfig> CATEGORY_CONFIGS = LoggerCache.createCategoryConfigs();
    private static final Map<ActionCategory, Queue<LogEntry>> unSavedLogsByCategory = new ConcurrentHashMap<ActionCategory, Queue<LogEntry>>();
    private static final Map<ActionCategory, ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>>> cachedLogsByCategory = new ConcurrentHashMap<ActionCategory, ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>>>();
    private static final ConcurrentHashMap<LocationCache, PlayerBlockLogEntry> placedBlockLogs = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, LRUCache<String, LogEntry>> playerRecentActions = new ConcurrentHashMap();
    private static final Cache<String, CachedQuery> queryCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final Cache<String, Long> countCache = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private static final AtomicLong totalLogsProcessed = new AtomicLong(0L);
    private static final AtomicInteger cacheHits = new AtomicInteger(0);
    private static final AtomicInteger cacheMisses = new AtomicInteger(0);

    private static Map<ActionCategory, CacheConfig> createCategoryConfigs() {
        HashMap<ActionCategory, CacheConfig> configs = new HashMap<ActionCategory, CacheConfig>();
        configs.put(ActionCategory.BLOCK_ACTIONS, new CacheConfig(500, 20, 300000L));
        configs.put(ActionCategory.ITEM_ACTIONS, new CacheConfig(300, 15, 600000L));
        configs.put(ActionCategory.ENTITY_ACTIONS, new CacheConfig(200, 10, 900000L));
        configs.put(ActionCategory.SYSTEM_ACTIONS, new CacheConfig(100, 5, 1800000L));
        configs.put(ActionCategory.COMMUNICATION_ACTIONS, new CacheConfig(50, 8, 1200000L));
        configs.put(ActionCategory.FLUID_ACTIONS, new CacheConfig(150, 12, 720000L));
        configs.put(ActionCategory.INVENTORY_ACTIONS, new CacheConfig(1000, 20, 300000L));
        configs.put(ActionCategory.SESSION_ACTIONS, new CacheConfig(100, 5, 1800000L));
        configs.put(ActionCategory.SIGN_ACTIONS, new CacheConfig(100, 5, 1800000L));
        configs.put(ActionCategory.UNKNOWN_ACTIONS, new CacheConfig(500, 5, 300000L));
        return configs;
    }

    private static CacheConfig getCategoryConfig(ActionCategory category) {
        return CATEGORY_CONFIGS.getOrDefault((Object)category, CATEGORY_CONFIGS.get((Object)ActionCategory.UNKNOWN_ACTIONS));
    }

    private static void initializeCaches() {
        for (ActionCategory category : ActionCategory.values()) {
            unSavedLogsByCategory.put(category, new ConcurrentLinkedQueue());
            cachedLogsByCategory.put(category, new ConcurrentHashMap());
        }
    }

    private static void startCleanupScheduler() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)StellarProtect.getInstance(), () -> {
            LoggerCache.clearRamCache();
            LoggerCache.cleanQueryCache();
        }, 6000L, 6000L);
    }

    public static void addLog(LogEntry logEntry) {
        ActionCategory category = ActionCategory.fromActionTypes(ActionType.getById(logEntry.getActionType()));
        LocationCache location = logEntry.asLocation();
        unSavedLogsByCategory.get((Object)category).add(logEntry);
        cachedLogsByCategory.get((Object)category).computeIfAbsent(location, k -> new ConcurrentLinkedQueue()).add(logEntry);
        if (logEntry instanceof PlayerBlockLogEntry && ActionType.getById(logEntry.getActionType()) == ActionType.BLOCK_PLACE) {
            placedBlockLogs.put(location, (PlayerBlockLogEntry)logEntry);
        }
        totalLogsProcessed.incrementAndGet();
        CacheConfig config = CATEGORY_CONFIGS.get((Object)category);
        if (unSavedLogsByCategory.get((Object)category).size() >= config.batchSize) {
            StellarProtect.getInstance().getCacheManager().forceSave(category);
        }
    }

    public static void loadLog(LogEntry logEntry) {
        ActionCategory category = ActionCategory.fromActionTypes(ActionType.getById(logEntry.getActionType()));
        LocationCache location = logEntry.asLocation();
        cachedLogsByCategory.get((Object)category).computeIfAbsent(location, k -> new ConcurrentLinkedQueue()).add(logEntry);
    }

    public static List<LogEntry> getFlushLogsToDatabase() {
        ArrayList<LogEntry> allBatch = new ArrayList<LogEntry>();
        for (ActionCategory category : ActionCategory.values()) {
            List<LogEntry> categoryBatch = LoggerCache.getFlushLogsToDatabase(category);
            allBatch.addAll(categoryBatch);
        }
        Debugger.debugSave("Flushing " + allBatch.size() + " logs to database.");
        return allBatch;
    }

    public static List<LogEntry> getFlushLogsToDatabase(ActionCategory category) {
        LogEntry entry;
        ArrayList<LogEntry> batch = new ArrayList<LogEntry>();
        Queue<LogEntry> categoryQueue = unSavedLogsByCategory.get((Object)category);
        CacheConfig config = LoggerCache.getCategoryConfig(category);
        for (int i = 0; i < config.batchSize && (entry = categoryQueue.poll()) != null; ++i) {
            batch.add(entry);
        }
        return batch;
    }

    public static List<ItemLogEntry> getChestTransactions(Location location, int skip, int limit) {
        LocationCache locationCache = LocationCache.of(location);
        ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>> cached = cachedLogsByCategory.get((Object)ActionCategory.INVENTORY_ACTIONS);
        ArrayList<ItemLogEntry> allItems = new ArrayList<ItemLogEntry>();
        if (cached.containsKey(locationCache)) {
            ConcurrentLinkedQueue<LogEntry> logs = cached.get(locationCache);
            for (LogEntry log : logs) {
                ItemStack item;
                ItemTemplate itemTemplate;
                if (!(log instanceof PlayerTransactionEntry)) continue;
                PlayerTransactionEntry transaction = (PlayerTransactionEntry)log;
                for (Map.Entry<Long, Integer> addedEntry : transaction.getAdded().entrySet()) {
                    itemTemplate = plugin.getItemsManager().getItemTemplate(addedEntry.getKey());
                    item = itemTemplate.getBukkitItem();
                    if (item == null) continue;
                    allItems.add(new ItemLogEntry(item, log.getPlayerId(), addedEntry.getValue(), true, log.getCreatedAt()));
                }
                for (Map.Entry<Long, Integer> removedEntry : transaction.getRemoved().entrySet()) {
                    itemTemplate = plugin.getItemsManager().getItemTemplate(removedEntry.getKey());
                    item = itemTemplate.getBukkitItem();
                    if (item == null) continue;
                    allItems.add(new ItemLogEntry(item, log.getPlayerId(), removedEntry.getValue(), false, log.getCreatedAt()));
                }
            }
        }
        return allItems.stream().sorted(Comparator.comparingLong(ItemLogEntry::getCreatedAt).reversed()).skip(skip).limit(limit).collect(Collectors.toList());
    }

    public static List<LogEntry> getLogs(DatabaseFilters databaseFilters, int skip, int limit) {
        TimeArg timeArg = databaseFilters.getTimeFilter();
        RadiusArg radiusArg = databaseFilters.getRadiusFilter();
        List<Integer> actionTypeIds = databaseFilters.getActionTypesFilter();
        UsersArg usersArg = databaseFilters.getUserFilters();
        List<ActionType> actionTypes = actionTypeIds.stream().map(ActionType::getById).collect(Collectors.toList());
        String actionKey = actionTypes.stream().map(Enum::name).collect(Collectors.joining(","));
        String userKey = !usersArg.getUserIds().isEmpty() ? usersArg.getUserIds().stream().map(String::valueOf).collect(Collectors.joining(",")) : "ALL";
        String cacheKey = (timeArg != null ? timeArg.getStart() + "_" + timeArg.getEnd() : "NOTIME") + "_" + (radiusArg != null ? radiusArg.toString() : "NORADIUS") + "_" + (!actionKey.isEmpty() ? actionKey : "ALL") + "_" + userKey + "_" + skip + "_" + limit;
        CachedQuery cached = (CachedQuery)queryCache.getIfPresent((Object)cacheKey);
        if (cached != null && !cached.isExpired()) {
            cacheHits.incrementAndGet();
            return cached.getLogs();
        }
        cacheMisses.incrementAndGet();
        HashSet<Integer> actionIds = new HashSet<Integer>(actionTypeIds);
        ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
        HashSet<ActionCategory> categoriesToSearch = new HashSet<ActionCategory>();
        if (actionTypes.isEmpty()) {
            categoriesToSearch.addAll(Arrays.asList(ActionCategory.values()));
        } else {
            categoriesToSearch.addAll(ActionCategory.fromActionTypes(actionTypes));
        }
        for (ActionCategory category : categoriesToSearch) {
            ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>> categoryCache = cachedLogsByCategory.get((Object)category);
            for (Map.Entry<LocationCache, ConcurrentLinkedQueue<LogEntry>> entry : categoryCache.entrySet()) {
                LocationCache cache = entry.getKey();
                if (radiusArg != null && !cache.isInside(radiusArg.getMinX(), radiusArg.getMaxX(), radiusArg.getMinY(), radiusArg.getMaxY(), radiusArg.getMinZ(), radiusArg.getMaxZ())) continue;
                for (LogEntry log : entry.getValue()) {
                    if (!actionTypeIds.isEmpty() && !actionIds.contains(log.getActionType()) || timeArg != null && (log.getCreatedAt() < timeArg.getStart() || log.getCreatedAt() > timeArg.getEnd()) || !usersArg.getUserIds().isEmpty() && !usersArg.getUserIds().contains(log.getPlayerId())) continue;
                    logs.add(log);
                }
            }
        }
        logs.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        List<LogEntry> paginatedLogs = logs.stream().skip(skip).limit(limit).collect(Collectors.toList());
        if (skip == 0 && limit <= 100) {
            queryCache.put((Object)cacheKey, (Object)new CachedQuery(paginatedLogs, System.currentTimeMillis() + 300000L));
        }
        return paginatedLogs;
    }

    @Deprecated
    public static List<LogEntry> getLogs(TimeArg timeArg, RadiusArg radiusArg, ActionType actionType, int skip, int limit) {
        return LoggerCache.getLogs(timeArg, radiusArg, actionType != null ? Collections.singletonList(actionType) : Collections.emptyList(), skip, limit);
    }

    @Deprecated
    public static List<LogEntry> getLogs(TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes, int skip, int limit) {
        String actionKey = actionTypes.stream().map(Enum::name).collect(Collectors.joining(","));
        String cacheKey = timeArg.getStart() + "_" + timeArg.getEnd() + "_" + radiusArg.toString() + "_" + (!actionKey.isEmpty() ? actionKey : "ALL") + "_" + skip + "_" + limit;
        CachedQuery cached = (CachedQuery)queryCache.getIfPresent((Object)cacheKey);
        if (cached != null && !cached.isExpired()) {
            cacheHits.incrementAndGet();
            return cached.getLogs();
        }
        cacheMisses.incrementAndGet();
        Set actionIds = actionTypes.stream().map(ActionType::getId).collect(Collectors.toSet());
        ArrayList<LogEntry> logs = new ArrayList<LogEntry>();
        HashSet<ActionCategory> categoriesToSearch = new HashSet<ActionCategory>();
        if (actionTypes.isEmpty()) {
            categoriesToSearch.addAll(ActionCategory.fromActionTypes(actionTypes));
        } else {
            categoriesToSearch.addAll(Arrays.asList(ActionCategory.values()));
        }
        for (ActionCategory category : categoriesToSearch) {
            ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>> categoryCache = cachedLogsByCategory.get((Object)category);
            for (Map.Entry<LocationCache, ConcurrentLinkedQueue<LogEntry>> entry : categoryCache.entrySet()) {
                LocationCache cache = entry.getKey();
                if (!cache.isInside(radiusArg.getMinX(), radiusArg.getMaxX(), radiusArg.getMinY(), radiusArg.getMaxY(), radiusArg.getMinZ(), radiusArg.getMaxZ())) continue;
                for (LogEntry log : entry.getValue()) {
                    if (!actionTypes.isEmpty() && !actionIds.contains(log.getActionType()) || log.getCreatedAt() < timeArg.getStart() || log.getCreatedAt() > timeArg.getEnd()) continue;
                    logs.add(log);
                }
            }
        }
        logs.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        List<LogEntry> paginatedLogs = logs.stream().skip(skip).limit(limit).collect(Collectors.toList());
        if (skip == 0 && limit <= 100) {
            queryCache.put((Object)cacheKey, (Object)new CachedQuery(paginatedLogs, System.currentTimeMillis() + 300000L));
        }
        return paginatedLogs;
    }

    public static long countLogs(TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes) {
        String actionKey = actionTypes.stream().map(Enum::name).collect(Collectors.joining(","));
        String countCacheKey = "COUNT_" + timeArg.getStart() + "_" + timeArg.getEnd() + "_" + radiusArg.toString() + "_" + (!actionKey.isEmpty() ? actionKey : "ALL");
        Long cached = (Long)countCache.getIfPresent((Object)countCacheKey);
        if (cached != null) {
            cacheHits.incrementAndGet();
            return cached;
        }
        cacheMisses.incrementAndGet();
        Set actionIds = actionTypes.stream().map(ActionType::getId).collect(Collectors.toSet());
        long count = 0L;
        HashSet<ActionCategory> categoriesToSearch = new HashSet<ActionCategory>();
        if (actionTypes.isEmpty()) {
            categoriesToSearch.addAll(Arrays.asList(ActionCategory.values()));
        } else {
            categoriesToSearch.addAll(ActionCategory.fromActionTypes(actionTypes));
        }
        for (ActionCategory category : categoriesToSearch) {
            ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>> categoryCache = cachedLogsByCategory.get((Object)category);
            for (Map.Entry<LocationCache, ConcurrentLinkedQueue<LogEntry>> entry : categoryCache.entrySet()) {
                LocationCache cache = entry.getKey();
                if (!cache.isInside(radiusArg.getMinX(), radiusArg.getMaxX(), radiusArg.getMinY(), radiusArg.getMaxY(), radiusArg.getMinZ(), radiusArg.getMaxZ())) continue;
                for (LogEntry log : entry.getValue()) {
                    if (!actionTypes.isEmpty() && !actionIds.contains(log.getActionType()) || log.getCreatedAt() < timeArg.getStart() || log.getCreatedAt() > timeArg.getEnd()) continue;
                    ++count;
                }
            }
        }
        return count;
    }

    public static List<LogEntry> getLogs(Location location, int skip, int limit) {
        LocationCache locationCache = LocationCache.of(location);
        return LoggerCache.getLogs(locationCache, skip, limit);
    }

    public static List<LogEntry> getLogs(LocationCache location, int skip, int limit) {
        ArrayList<LogEntry> allLogs = new ArrayList<LogEntry>();
        for (ActionCategory category : ActionCategory.values()) {
            ConcurrentLinkedQueue<LogEntry> categoryLogs = cachedLogsByCategory.get((Object)category).get(location);
            if (categoryLogs == null) continue;
            allLogs.addAll(categoryLogs);
        }
        allLogs.sort((a, b) -> Long.compare(b.getCreatedAt(), a.getCreatedAt()));
        return allLogs.stream().skip(skip).limit(limit).collect(Collectors.toList());
    }

    public static boolean hasLogs(LocationCache location) {
        for (ActionCategory category : ActionCategory.values()) {
            if (!cachedLogsByCategory.get((Object)category).containsKey(location)) continue;
            return true;
        }
        return false;
    }

    public static LogEntry getPlacedBlockLog(Location location) {
        return placedBlockLogs.get(LocationCache.of(location));
    }

    public static List<LogEntry> getPlayerRecentActions(String playerName, ActionCategory category, int limit) {
        LRUCache<String, LogEntry> playerCache = playerRecentActions.get(playerName);
        if (playerCache == null) {
            return new ArrayList<LogEntry>();
        }
        ArrayList<LogEntry> result = new ArrayList<LogEntry>();
        for (Map.Entry entry : playerCache.entrySet()) {
            if (!((String)entry.getKey()).startsWith(category.name())) continue;
            result.add((LogEntry)entry.getValue());
            if (result.size() < limit) continue;
            break;
        }
        return result;
    }

    public static void clearRamCache() {
        long currentTime = System.currentTimeMillis();
        for (ActionCategory category : ActionCategory.values()) {
            CacheConfig config = CATEGORY_CONFIGS.get((Object)category);
            long limit = currentTime - config.cacheRetentionTime;
            ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>> categoryCache = cachedLogsByCategory.get((Object)category);
            Iterator<Map.Entry<LocationCache, ConcurrentLinkedQueue<LogEntry>>> mapIterator = categoryCache.entrySet().iterator();
            while (mapIterator.hasNext()) {
                Map.Entry<LocationCache, ConcurrentLinkedQueue<LogEntry>> entry2 = mapIterator.next();
                ConcurrentLinkedQueue<LogEntry> logs = LoggerCache.cleanLogQueue(entry2.getValue(), limit, config.maxLogsPerLocation);
                if (!logs.isEmpty()) continue;
                mapIterator.remove();
            }
        }
        long placedLimit = currentTime - 30000L;
        placedBlockLogs.entrySet().removeIf(entry -> ((PlayerBlockLogEntry)entry.getValue()).getCreatedAt() < placedLimit);
        Iterator<Map.Entry<String, LRUCache<String, LogEntry>>> playerIterator = playerRecentActions.entrySet().iterator();
        while (playerIterator.hasNext()) {
            Map.Entry<String, LRUCache<String, LogEntry>> entry3 = playerIterator.next();
            entry3.getValue().removeOldEntries(currentTime - 600000L);
            if (!entry3.getValue().isEmpty()) continue;
            playerIterator.remove();
        }
    }

    private static ConcurrentLinkedQueue<LogEntry> cleanLogQueue(ConcurrentLinkedQueue<LogEntry> logs, long timeLimit, int maxLogs) {
        logs.removeIf(log -> log.getCreatedAt() < timeLimit);
        while (logs.size() > maxLogs) {
            logs.poll();
        }
        return logs;
    }

    private static void cleanQueryCache() {
        queryCache.cleanUp();
        countCache.cleanUp();
    }

    @Generated
    public static Map<ActionCategory, CacheConfig> getCATEGORY_CONFIGS() {
        return CATEGORY_CONFIGS;
    }

    @Generated
    public static Map<ActionCategory, Queue<LogEntry>> getUnSavedLogsByCategory() {
        return unSavedLogsByCategory;
    }

    @Generated
    public static Map<ActionCategory, ConcurrentHashMap<LocationCache, ConcurrentLinkedQueue<LogEntry>>> getCachedLogsByCategory() {
        return cachedLogsByCategory;
    }

    @Generated
    public static ConcurrentHashMap<LocationCache, PlayerBlockLogEntry> getPlacedBlockLogs() {
        return placedBlockLogs;
    }

    @Generated
    public static ConcurrentHashMap<String, LRUCache<String, LogEntry>> getPlayerRecentActions() {
        return playerRecentActions;
    }

    @Generated
    public static Cache<String, CachedQuery> getQueryCache() {
        return queryCache;
    }

    @Generated
    public static Cache<String, Long> getCountCache() {
        return countCache;
    }

    static {
        LoggerCache.initializeCaches();
        LoggerCache.startCleanupScheduler();
    }

    private static class CacheConfig {
        final int batchSize;
        final int maxLogsPerLocation;
        final long cacheRetentionTime;

        CacheConfig(int batchSize, int maxLogsPerLocation, long cacheRetentionTime) {
            this.batchSize = batchSize;
            this.maxLogsPerLocation = maxLogsPerLocation;
            this.cacheRetentionTime = cacheRetentionTime;
        }
    }

    private static class CachedQuery {
        private final List<LogEntry> logs;
        private final long expireTime;

        public CachedQuery(List<LogEntry> logs, long expireTime) {
            this.logs = logs;
            this.expireTime = expireTime;
        }

        public boolean isExpired() {
            return this.isExpired(System.currentTimeMillis());
        }

        public boolean isExpired(long currentTime) {
            return currentTime > this.expireTime;
        }

        @Generated
        public List<LogEntry> getLogs() {
            return this.logs;
        }

        @Generated
        public long getExpireTime() {
            return this.expireTime;
        }
    }

    private static class LRUCache<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        public LRUCache(int maxSize) {
            super(16, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }

        public void removeOldEntries(long timeLimit) {
            Iterator iterator = this.entrySet().iterator();
            while (iterator.hasNext()) {
                LogEntry logEntry;
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof LogEntry) || (logEntry = (LogEntry)entry.getValue()).getCreatedAt() >= timeLimit) continue;
                iterator.remove();
            }
        }
    }
}

