/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.commands;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.commands.StellarArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.DebugArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.InspectArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.LookupArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.MemoryArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.NextInspectArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.NextLookupArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.PurgeArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.RestoreArgument;
import io.github.InsiderAnh.StellarProtect.commands.arguments.VersionArgument;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;

public class StellarProtectCMD
implements TabExecutor {
    private final StellarProtect plugin = StellarProtect.getInstance();
    private final HashMap<String, StellarArgument> arguments = new HashMap();

    public StellarProtectCMD() {
        this.arguments.put("lookup", new LookupArgument());
        this.arguments.put("nextlookup", new NextLookupArgument());
        this.arguments.put("inspect", new InspectArgument());
        this.arguments.put("purge", new PurgeArgument());
        this.arguments.put("nextinspect", new NextInspectArgument());
        this.arguments.put("debug", new DebugArgument());
        this.arguments.put("memory", new MemoryArgument());
        this.arguments.put("version", new VersionArgument());
        this.arguments.put("restore", new RestoreArgument());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (this.hasBlockedPermission(sender, "default")) {
            return false;
        }
        if (args.length < 1) {
            this.sendHelp(sender);
            return false;
        }
        switch (args[0].toLowerCase()) {
            case "reload": {
                if (this.hasBlockedPermission(sender, "admin")) {
                    return false;
                }
                this.plugin.reload();
                this.plugin.getLangManager().sendMessage(sender, "messages.reloaded");
                break;
            }
            case "i": 
            case "inspect": {
                if (this.hasBlockedPermission(sender, "inspect")) {
                    return false;
                }
                this.arguments.get("inspect").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "ni": 
            case "nextinspect": {
                if (this.hasBlockedPermission(sender, "inspect")) {
                    return false;
                }
                this.arguments.get("nextinspect").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "s": 
            case "l": 
            case "search": 
            case "lookup": {
                if (this.hasBlockedPermission(sender, "lookup")) {
                    return false;
                }
                this.arguments.get("lookup").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "nl": 
            case "nextlookup": {
                if (this.hasBlockedPermission(sender, "lookup")) {
                    return false;
                }
                this.arguments.get("nextlookup").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "purge": {
                if (this.hasBlockedPermission(sender, "purge")) {
                    return false;
                }
                this.arguments.get("purge").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "debug": {
                if (this.hasBlockedPermission(sender, "admin")) {
                    return false;
                }
                this.arguments.get("debug").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "v": 
            case "version": {
                this.arguments.get("version").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "mem": 
            case "memory": {
                if (this.hasBlockedPermission(sender, "memory")) {
                    return false;
                }
                this.arguments.get("memory").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            case "restore": 
            case "rollback": {
                if (this.hasBlockedPermission(sender, "rollback")) {
                    return false;
                }
                this.arguments.get("restore").onCommand(sender, Arrays.copyOfRange(args, 1, args.length));
                break;
            }
            default: {
                this.sendHelp(sender);
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length >= 1) {
            String arg;
            switch (arg = args[0].toLowerCase()) {
                case "inspect": 
                case "i": {
                    return this.arguments.get("inspect").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "search": 
                case "lookup": 
                case "s": 
                case "l": {
                    return this.arguments.get("lookup").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "purge": {
                    return this.arguments.get("purge").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "debug": {
                    return this.arguments.get("debug").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "mem": 
                case "memory": {
                    return this.arguments.get("memory").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
                case "restore": 
                case "rollback": {
                    return this.arguments.get("restore").onTabComplete(sender, Arrays.copyOfRange(args, 1, args.length));
                }
            }
            return Stream.of("reload", "version", "help", "lookup", "inspect", "purge", "memory", "debug", "restore").filter(s -> s.startsWith(arg)).collect(Collectors.toList());
        }
        return Arrays.asList("reload", "version", "help", "lookup", "inspect", "purge", "memory", "debug", "restore");
    }

    void sendHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        sender.sendMessage(ChatColor.DARK_GRAY + "[!] " + ChatColor.RED + "StellarProtect " + ChatColor.DARK_GRAY + "[!]");
        sender.sendMessage(ChatColor.GRAY + "" + ChatColor.STRIKETHROUGH + "+---------------------------------------+");
        sender.sendMessage(ChatColor.YELLOW + "/sp reload " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Reload the plugin.");
        sender.sendMessage(ChatColor.YELLOW + "/sp help " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Show this help.");
        sender.sendMessage(ChatColor.YELLOW + "/sp version " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Show the plugin version.");
        sender.sendMessage(ChatColor.YELLOW + "/sp inspect " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Enable/disable inspection mode.");
        sender.sendMessage(ChatColor.YELLOW + "/sp lookup p:<page> t:<time> r:<radius> " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Search for logs in a radius.");
        sender.sendMessage(ChatColor.YELLOW + "/sp restore p:<page> t:<time> r:<radius> " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Restore logs in a radius.");
        sender.sendMessage(ChatColor.YELLOW + "/sp purge p:<page> t:<time> r:<radius> " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Purge logs in a radius.");
        sender.sendMessage(ChatColor.YELLOW + "/sp debug save|log|extras " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Enable/disable debug mode.");
        sender.sendMessage(ChatColor.YELLOW + "/sp memory " + ChatColor.GRAY + "- " + ChatColor.WHITE + "Show memory analysis.");
    }

    boolean hasBlockedPermission(CommandSender sender, String permission) {
        if (sender.hasPermission("stellarprotect." + permission) || sender.hasPermission("stellarprotect.admin") || sender.isOp()) {
            return false;
        }
        this.plugin.getLangManager().sendMessage(sender, "messages.noPermission");
        return true;
    }
}

