/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.commands.arguments;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.ArgumentsParser;
import io.github.InsiderAnh.StellarProtect.arguments.DatabaseFilters;
import io.github.InsiderAnh.StellarProtect.arguments.PageArg;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.arguments.UsersArg;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.commands.StellarArgument;
import io.github.InsiderAnh.StellarProtect.data.LookupSession;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import io.github.InsiderAnh.StellarProtect.utils.WorldUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class LookupArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        PageArg pageArg = ArgumentsParser.parsePage(arguments);
        TimeArg timeArg = ArgumentsParser.parseTime(arguments);
        RadiusArg radiusArg = ArgumentsParser.parseRadius(arguments, player.getLocation());
        List<ActionType> actionTypesArg = ArgumentsParser.parseActionTypes(arguments);
        if (playerProtect.getNextLookup() > System.currentTimeMillis()) {
            this.plugin.getLangManager().sendMessage(sender, "messages.waitingForLookup");
            return;
        }
        playerProtect.setNextLookup(System.currentTimeMillis() + 10000L);
        ArgumentsParser.parseUsers(arguments).thenAccept(usersArg -> {
            DatabaseFilters databaseFilters = new DatabaseFilters();
            databaseFilters.setTimeFilter(timeArg);
            databaseFilters.setRadiusFilter(radiusArg);
            databaseFilters.setPageFilter(pageArg);
            databaseFilters.setActionTypesFilter(actionTypesArg.stream().map(ActionType::getId).collect(Collectors.toCollection(ArrayList::new)));
            databaseFilters.setUserFilters((UsersArg)usersArg);
            playerProtect.setInspectSession(null);
            playerProtect.setLookupSession(new LookupSession(pageArg, databaseFilters, 0, 10));
            this.plugin.getLangManager().sendMessage(sender, "messages.loadingLookup");
            ((CompletableFuture)this.plugin.getProtectDatabase().getLogs(databaseFilters, pageArg.getSkip(), pageArg.getLimit()).thenAccept(callbackLookup -> {
                Map groupedLogs = (Map)callbackLookup.getLogs();
                long total = (long)Math.ceil((double)((Long)callbackLookup.getTotal()).longValue() / (double)pageArg.getPerPage());
                playerProtect.setNextLookup(System.currentTimeMillis() + 500L);
                for (Map.Entry entry : groupedLogs.entrySet()) {
                    LocationCache location = (LocationCache)entry.getKey();
                    Set logs = (Set)entry.getValue();
                    this.plugin.getProtectNMS().sendActionTitle(player, this.plugin.getLangManager().get("messages.actions.title"), "\u00a7fClick to teleport!", "/tp " + location.getX() + " " + location.getY() + " " + location.getZ(), text -> text.replace("<location>", WorldUtils.getFormatedLocation(location)));
                    for (LogEntry logEntry : logs) {
                        ActionType actionType = ActionType.getById(logEntry.getActionType());
                        if (actionType == null) continue;
                        this.plugin.getInspectHandler().processLogEntry(player, logEntry);
                    }
                }
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.pages");
                this.plugin.getProtectNMS().sendPageButtons(player, this.plugin.getLangManager().get("messages.currentPage"), this.plugin.getLangManager().get("messages.lastPage"), this.plugin.getLangManager().get("messages.nextPage"), pageArg.getPage(), pageArg.getPerPage(), (int)total);
            })).exceptionally(error -> {
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noLogs");
                playerProtect.setNextLookup(System.currentTimeMillis() + 500L);
                error.printStackTrace();
                Debugger.debugLog("Error on lookup: " + error.getMessage());
                return null;
            });
        });
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        if (arguments.length >= 1) {
            String currentArg = arguments[arguments.length - 1];
            if (currentArg.startsWith("a:") || currentArg.startsWith("action:")) {
                return ActionType.getAllNames(currentArg.replaceFirst("a:", "").replaceFirst("action:", "").toLowerCase());
            }
            if (currentArg.startsWith("t:") || currentArg.startsWith("time:")) {
                return Arrays.asList("t:1h", "t:1d", "t:1w", "t:1mo");
            }
            if (currentArg.startsWith("r:") || currentArg.startsWith("radius:")) {
                return Arrays.asList("r:10", "r:20", "r:30", "r:40", "r:50");
            }
            if (currentArg.startsWith("p:") || currentArg.startsWith("page:")) {
                return Arrays.asList("p:1-10", "p:1-20", "p:1-30");
            }
            if (currentArg.startsWith("u:") || currentArg.startsWith("users:")) {
                String name = currentArg.replaceFirst("^(u:|users:)", "");
                ArrayList<String> names = new ArrayList<String>();
                AtomicInteger max = new AtomicInteger(0);
                for (Player player : Bukkit.getOnlinePlayers()) {
                    if (!player.getName().toLowerCase().contains(name.toLowerCase())) continue;
                    names.add("u:" + player.getName());
                    max.getAndIncrement();
                    if (max.get() < 10) continue;
                    break;
                }
                return names;
            }
        }
        return Arrays.asList("t:1h", "r:10", "p:1-10", "a:block_break", "u:player");
    }
}

