/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.DatabaseFilters;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.callback.CallbackLookup;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.items.ItemLogEntry;
import io.github.InsiderAnh.StellarProtect.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.StellarProtect.database.types.MongoConnection;
import io.github.InsiderAnh.StellarProtect.database.types.MySQLConnection;
import io.github.InsiderAnh.StellarProtect.database.types.SQLConnection;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class ProtectDatabase {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private DatabaseConnection databaseConnection;

    public void connect() {
        String databaseType = this.stellarProtect.getConfig().getString("databases.databaseType", "h2");
        this.databaseConnection = databaseType.equalsIgnoreCase("mysql") ? new MySQLConnection() : (databaseType.equalsIgnoreCase("mongodb") ? new MongoConnection() : new SQLConnection());
        this.databaseConnection.connect();
        this.databaseConnection.createIndexes();
    }

    public void load() {
        this.databaseConnection.getLoggerRepository().loadTemporaryLogs();
        this.databaseConnection.getIdsRepository().loadWorlds();
        this.databaseConnection.getIdsRepository().loadEntityIds();
        this.databaseConnection.getItemsRepository().loadMostUsedItems();
    }

    public void close() {
        this.databaseConnection.close();
    }

    public void clearOldLogs() {
        this.databaseConnection.getLoggerRepository().clearOldLogs();
    }

    public void purgeLogs(@NonNull DatabaseFilters databaseFilters) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        this.databaseConnection.getLoggerRepository().purgeLogs(databaseFilters);
    }

    public CompletableFuture<CallbackLookup<List<ItemLogEntry>, Long>> getChestTransactions(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.databaseConnection.getLoggerRepository().getChestTransactions(location, skip, limit);
    }

    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getLogs(@NonNull DatabaseFilters databaseFilters, int skip, int limit) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        return this.databaseConnection.getLoggerRepository().getLogs(databaseFilters, skip, limit);
    }

    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getRestoreActions(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, @NonNull List<ActionType> actionTypes, int skip, int limit) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        if (actionTypes == null) {
            throw new NullPointerException("actionTypes is marked non-null but is null");
        }
        return this.databaseConnection.getRestoreRepository().getRestoreActions(timeArg, radiusArg, actionTypes, skip, limit);
    }

    public CompletableFuture<Long> countRestoreActions(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, List<ActionType> actionTypes) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        return this.databaseConnection.getRestoreRepository().countRestoreActions(timeArg, radiusArg, actionTypes);
    }

    public CompletableFuture<CallbackLookup<Set<LogEntry>, Long>> getLogs(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return this.databaseConnection.getLoggerRepository().getLogs(location, skip, limit);
    }

    public List<Long> getIdsByNames(List<String> names) {
        return this.databaseConnection.getPlayerRepository().getIdsByNames(names);
    }

    public PlayerProtect loadOrCreatePlayer(Player player) {
        return this.databaseConnection.getPlayerRepository().loadOrCreatePlayer(player);
    }

    public void save(List<LogEntry> logEntries) {
        if (logEntries.isEmpty()) {
            return;
        }
        this.databaseConnection.getLoggerRepository().save(logEntries);
    }

    public void saveWorld(String world, int id) {
        this.databaseConnection.getIdsRepository().saveWorld(world, id);
    }

    public void saveEntityId(String entityType, long id) {
        this.databaseConnection.getIdsRepository().saveEntityId(entityType, id);
    }

    public void saveItems(List<ItemTemplate> itemTemplates) {
        this.databaseConnection.getItemsRepository().saveItems(itemTemplates);
    }
}

