/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.block.Block;

public class PlayerUseEntry
extends LogEntry {
    private final String material;

    public PlayerUseEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.material = jsonObject.get("m").getAsString();
    }

    public PlayerUseEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.material = jsonObject.get("m").getAsString();
    }

    public PlayerUseEntry(long playerId, Block block, ActionType actionType) {
        super(playerId, actionType.getId(), block.getLocation(), System.currentTimeMillis());
        this.material = block.getType().name();
    }

    @Override
    public String getDataString() {
        return this.material;
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerUseEntry entry = this;
        obj.addProperty("m", entry.getMaterial());
        return obj.toString();
    }

    @Generated
    public String getMaterial() {
        return this.material;
    }
}

