/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.DatabaseConnection;
import io.github.InsiderAnh.StellarProtect.database.repositories.IdsRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.ItemsRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.LoggerRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.PlayerRepository;
import io.github.InsiderAnh.StellarProtect.database.repositories.RestoreRepository;
import io.github.InsiderAnh.StellarProtect.database.types.sql.IdsRepositorySQL;
import io.github.InsiderAnh.StellarProtect.database.types.sql.ItemsRepositorySQL;
import io.github.InsiderAnh.StellarProtect.database.types.sql.LoggerRepositorySQL;
import io.github.InsiderAnh.StellarProtect.database.types.sql.PlayerRepositorySQL;
import io.github.InsiderAnh.StellarProtect.database.types.sql.RestoreRepositorySQL;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;

public class SQLConnection
implements DatabaseConnection {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private PlayerRepository playerRepository;
    private LoggerRepository loggerRepository;
    private IdsRepository idsRepository;
    private ItemsRepository itemsRepository;
    private RestoreRepository restoreRepository;
    private Connection connection;

    @Override
    public void connect() {
        try {
            File dbFile = new File(this.stellarProtect.getDataFolder(), this.stellarProtect.getConfig().getString("databases.h2.database") + ".db");
            if (!dbFile.exists()) {
                dbFile.createNewFile();
            }
            Class.forName("org.sqlite.JDBC");
            this.connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile);
            try (Statement statement = this.connection.createStatement();){
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS players (id BIGINT PRIMARY KEY,uuid VARCHAR(36) NOT NULL,name VARCHAR(36))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS worlds (id INT PRIMARY KEY,name TEXT NOT NULL)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS entity_ids (id BIGINT PRIMARY KEY,entityType TEXT NOT NULL)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS log_entries (id INTEGER PRIMARY KEY AUTOINCREMENT,player_id BIGINT,world_id INT,x DECIMAL(8, 2),y DECIMAL(8, 2),z DECIMAL(8, 2),action_type INT,extra_json TEXT,created_at BIGINT,FOREIGN KEY (player_id) REFERENCES players(id),FOREIGN KEY (world_id) REFERENCES worlds(id))");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS id_counter (table_name TEXT PRIMARY KEY,current_id BIGINT)");
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS item_templates (id INTEGER PRIMARY KEY,base64 TEXT,s TINYINT,access_count INTEGER DEFAULT 0,last_accessed TIMESTAMP DEFAULT CURRENT_TIMESTAMP,total_quantity_used INTEGER DEFAULT 0,created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP)");
                statement.executeUpdate("CREATE INDEX IF NOT EXISTS idx_log_entries_filtering ON log_entries (created_at, x, y, z)");
            }
            catch (Exception exception) {
                this.stellarProtect.getLogger().warning("Error on connect to SQLite database " + exception.getMessage());
                return;
            }
            try (Statement stmt = this.connection.createStatement();){
                stmt.execute("PRAGMA journal_mode = WAL");
                stmt.execute("PRAGMA synchronous = NORMAL");
                stmt.execute("PRAGMA cache_size = 10000");
                stmt.execute("PRAGMA temp_store = MEMORY");
            }
            catch (SQLException e) {
                this.stellarProtect.getLogger().warning("Failed to configure SQLite for performance");
            }
            this.playerRepository = new PlayerRepositorySQL(this.connection);
            this.loggerRepository = new LoggerRepositorySQL(this.connection);
            this.idsRepository = new IdsRepositorySQL(this.connection);
            this.itemsRepository = new ItemsRepositorySQL(this.connection);
            this.restoreRepository = new RestoreRepositorySQL(this.connection);
            this.stellarProtect.getLogger().info("Connected to SQLite database correctly.");
        }
        catch (Exception exception) {
            this.stellarProtect.getLogger().warning("Error on connect to SQLite database " + exception.getMessage());
        }
    }

    @Override
    public void createIndexes() {
        try (Statement stmt = this.connection.createStatement();){
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_query_main ON log_entries (created_at, action_type, x, y, z)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_log_entries_optimized ON log_entries (created_at DESC, action_type, x, y, z, player_id)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_action_time_coords ON log_entries (action_type, created_at, x, y, z)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_time_action ON log_entries (created_at, action_type)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_player_time ON log_entries (player_id, created_at)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_world_time ON log_entries (world_id, created_at)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_hash ON item_templates(base64)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_access_count ON item_templates(access_count DESC)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_last_accessed ON item_templates(last_accessed DESC)");
            stmt.execute("CREATE INDEX IF NOT EXISTS idx_item_total_used ON item_templates(total_quantity_used DESC)");
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().info("Failed to create indexes");
        }
    }

    @Override
    public void close() {
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().warning("Error on close SQLite connection: " + e.getMessage());
        }
    }

    @Generated
    public StellarProtect getStellarProtect() {
        return this.stellarProtect;
    }

    @Override
    @Generated
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    @Generated
    public LoggerRepository getLoggerRepository() {
        return this.loggerRepository;
    }

    @Override
    @Generated
    public IdsRepository getIdsRepository() {
        return this.idsRepository;
    }

    @Override
    @Generated
    public ItemsRepository getItemsRepository() {
        return this.itemsRepository;
    }

    @Override
    @Generated
    public RestoreRepository getRestoreRepository() {
        return this.restoreRepository;
    }

    @Generated
    public Connection getConnection() {
        return this.connection;
    }
}

