/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.mongo;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.ItemsRepository;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.libs.bson.conversions.Bson;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.bulk.BulkWriteResult;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Aggregates;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.BulkWriteOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Filters;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Projections;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.ReplaceOneModel;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.ReplaceOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Sorts;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import io.github.InsiderAnh.StellarProtect.utils.InventorySerializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.bukkit.inventory.ItemStack;

public class ItemsRepositoryMongo
implements ItemsRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final MongoDatabase database;
    private final MongoCollection<Document> item_templates;

    public ItemsRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.item_templates = database.getCollection("item_templates");
    }

    @Override
    public void saveItems(List<ItemTemplate> itemTemplates) {
        this.stellarProtect.getExecutor().execute(() -> {
            try {
                ArrayList<Document> documents = new ArrayList<Document>();
                for (Object template : itemTemplates) {
                    Document doc = new Document().append("_id", ((ItemTemplate)template).getId()).append("base64", ((ItemTemplate)template).getBase64()).append("s", ((ItemTemplate)template).getShorted()).append("access_count", 0).append("last_accessed", new Date()).append("total_quantity_used", 0).append("created_at", new Date());
                    documents.add(doc);
                }
                ArrayList<ReplaceOneModel<Document>> operations = new ArrayList<ReplaceOneModel<Document>>();
                for (Document doc : documents) {
                    ReplaceOneModel<Document> replaceModel = new ReplaceOneModel<Document>(Filters.eq("_id", doc.get("_id")), doc, new ReplaceOptions().upsert(true));
                    operations.add(replaceModel);
                }
                BulkWriteOptions bulkWriteOptions = new BulkWriteOptions().ordered(false).bypassDocumentValidation(false);
                int batchSize = 1000;
                int totalProcessed = 0;
                for (int i = 0; i < operations.size(); i += batchSize) {
                    int endIndex = Math.min(i + batchSize, operations.size());
                    List batch = operations.subList(i, endIndex);
                    BulkWriteResult result = this.item_templates.bulkWrite(batch, bulkWriteOptions);
                    Debugger.debugSave("Processed MongoDB: " + (totalProcessed += batch.size()) + "/" + operations.size() + " item templates " + result.getModifiedCount());
                }
                Debugger.debugSave("Saved " + itemTemplates.size() + " item templates in MongoDB");
            }
            catch (Exception e) {
                Debugger.debugSave("Error on save items in MongoDB: " + e.getMessage());
                e.printStackTrace();
            }
        });
    }

    @Override
    public void updateItemUsageInDatabase(long templateId, int quantity) {
    }

    @Override
    public void loadMostUsedItems() {
        try {
            MongoCollection<Document> collection = this.database.getCollection("item_templates");
            List<Bson> pipeline = Arrays.asList(Aggregates.sort(Sorts.orderBy(Sorts.descending("access_count"), Sorts.descending("total_quantity_used"))), Aggregates.limit(5000), Aggregates.project(Projections.fields(Projections.include("_id", "base64", "s", "access_count", "last_accessed", "total_quantity_used", "created_at"))));
            try (MongoCursor cursor = collection.aggregate(pipeline).iterator();){
                while (cursor.hasNext()) {
                    Document doc = (Document)cursor.next();
                    long id = doc.getLong("_id");
                    String base64 = doc.getString("base64");
                    byte shorted = (byte)doc.getInteger("s", 0);
                    String fullBase64 = shorted == 1 ? "rO0ABXNyABpvcmcuYnVra2l0LnV0aWwuaW8uV3JhcHBlcvJQR+zxEm8FAgABTAADbWFwdAAPTGphdmEvdXRpbC9NYXA7eHBzcgA1Y29tLmdvb2dsZS5jb21tb24uY29sbGVjdC5JbW11dGFibGVNYXAkU2VyaWFsaXplZEZvcm0AAAAAAAAAAAIAAkwABGtleXN0ABJMamF2YS9sYW5nL09iamVjdDtMAAZ2YWx1ZXNxAH4ABHhwdXIAE1tMamF2YS5sYW5nLk9iamVjdDuQzlifEHMpbAIAAHhwAAAABXQAAj09dAALRGF0YVZlcnNpb250AAJpZHQABWNvdW50dAAOc2NoZW1hX3ZlcnNpb251cQB+AAYAAAAFdAAeb3JnLmJ1a2tpdC5pbnZlbnRvcnkuSXRlbVN0YWNrc3IAEWphdmEubGFuZy5JbnRlZ2VyEuKgpPeB" + base64 : base64;
                    ItemStack bukkitItem = InventorySerializable.itemStackFromBase64(fullBase64);
                    ItemTemplate template = new ItemTemplate(id, bukkitItem, fullBase64);
                    this.stellarProtect.getItemsManager().loadItemReference(template, fullBase64);
                }
            }
            this.stellarProtect.getLogger().info("Loaded " + this.stellarProtect.getItemsManager().getItemReferenceCount() + " item references.");
        }
        catch (Exception e) {
            this.stellarProtect.getLogger().info("Error en loadMostUsedItems: " + e.getMessage());
        }
    }
}

