/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.mongo;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.DatabaseFilters;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.arguments.UsersArg;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.callback.CallbackLookup;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.items.ItemLogEntry;
import io.github.InsiderAnh.StellarProtect.database.entries.players.PlayerTransactionEntry;
import io.github.InsiderAnh.StellarProtect.database.repositories.LoggerRepository;
import io.github.InsiderAnh.StellarProtect.database.types.factory.LogEntryFactory;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.items.ItemTemplate;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.libs.bson.conversions.Bson;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.bulk.BulkWriteResult;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.FindIterable;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.BulkWriteOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Filters;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.InsertOneModel;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Sorts;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.result.DeleteResult;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.bukkit.Location;
import org.bukkit.inventory.ItemStack;

public class LoggerRepositoryMongo
implements LoggerRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final MongoDatabase database;
    private final MongoCollection<Document> players;
    private final MongoCollection<Document> logEntries;

    public LoggerRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.players = database.getCollection("players");
        this.logEntries = database.getCollection("log_entries");
    }

    @Override
    public void loadTemporaryLogs() {
        Debugger.debugLog("Loading logs from database...");
        AtomicInteger count = new AtomicInteger(0);
        long twelveHoursAgo = System.currentTimeMillis() - 43200000L;
        FindIterable<Document> findPlayerLogEntries = this.logEntries.find(Filters.gte("created_at", twelveHoursAgo)).sort(Sorts.descending("created_at")).limit(10000);
        for (Document doc : findPlayerLogEntries) {
            long playerId = doc.getLong("player_id");
            Document playerDoc = (Document)this.players.find(Filters.eq("id", playerId)).first();
            if (playerDoc != null) {
                String playerName = playerDoc.getString("name");
                PlayerCache.cacheName(playerId, playerName);
            }
            try {
                LoggerCache.loadLog(LogEntryFactory.fromDocument(doc));
                count.incrementAndGet();
            }
            catch (Exception ignored) {
                String data = doc.getString("data");
                Debugger.debugLog("Failed to load log entry: " + data);
            }
        }
        Debugger.debugLog("Loaded " + count.get() + " logs from database (most recent first, max 10k).");
    }

    @Override
    public void clearOldLogs() {
        Debugger.debugLog("Clearing old logs...");
        this.stellarProtect.getExecutor().execute(() -> {
            int daysToKeep = this.stellarProtect.getConfigManager().getDaysToKeepLogs();
            long cutoffTime = System.currentTimeMillis() - (long)daysToKeep * 24L * 60L * 60L * 1000L;
            Bson filter = Filters.lt("created_at", cutoffTime);
            DeleteResult result = this.logEntries.deleteMany(filter);
            Debugger.debugLog("Cleared " + result.getDeletedCount() + " logs from database.");
        });
    }

    @Override
    public void save(List<LogEntry> logEntries) {
        if (logEntries.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        Debugger.debugSave("Saving log entries...");
        this.stellarProtect.getExecutor().execute(() -> {
            try {
                ArrayList<InsertOneModel<Document>> playerOps = new ArrayList<InsertOneModel<Document>>(logEntries.size());
                for (LogEntry logEntry : logEntries) {
                    String extraJson = logEntry.toSaveJson();
                    Document doc = new Document("world_id", logEntry.getWorldId()).append("player_id", logEntry.getPlayerId()).append("x", logEntry.getX()).append("y", logEntry.getY()).append("z", logEntry.getZ()).append("action_type", logEntry.getActionType()).append("extra_json", extraJson).append("created_at", logEntry.getCreatedAt());
                    playerOps.add(new InsertOneModel<Document>(doc));
                }
                BulkWriteOptions options = new BulkWriteOptions().ordered(false).bypassDocumentValidation(true);
                BulkWriteResult result = this.logEntries.bulkWrite(playerOps, options);
                Debugger.debugSave("Saved " + result.getInsertedCount() + " log entries in " + (System.currentTimeMillis() - start) + "ms");
            }
            catch (Exception e) {
                this.stellarProtect.getLogger().log(Level.SEVERE, "Failed to save log entries to MongoDB", e);
            }
        });
    }

    @Override
    public void purgeLogs(@NonNull DatabaseFilters databaseFilters) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        long start = System.currentTimeMillis();
        Debugger.debugSave("Purging logs...");
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1024)));
        executor.execute(() -> {
            TimeArg timeArg = databaseFilters.getTimeFilter();
            RadiusArg radiusArg = databaseFilters.getRadiusFilter();
            UsersArg usersArg = databaseFilters.getUserFilters();
            List<Integer> actionTypes = databaseFilters.getActionTypesFilter();
            ArrayList<Bson> filters = new ArrayList<Bson>();
            if (timeArg != null) {
                filters.add(Filters.gte("created_at", timeArg.getStart()));
                filters.add(Filters.lte("created_at", timeArg.getEnd()));
            }
            if (radiusArg != null) {
                filters.add(Filters.gte("x", radiusArg.getMinX()));
                filters.add(Filters.lte("x", radiusArg.getMaxX()));
                filters.add(Filters.gte("y", radiusArg.getMinY()));
                filters.add(Filters.lte("y", radiusArg.getMaxY()));
                filters.add(Filters.gte("z", radiusArg.getMinZ()));
                filters.add(Filters.lte("z", radiusArg.getMaxZ()));
            }
            if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
                filters.add(Filters.in("player_id", usersArg.getUserIds()));
            }
            if (actionTypes != null && !actionTypes.isEmpty()) {
                filters.add(Filters.in("action_type", actionTypes));
            }
            if (filters.isEmpty()) {
                Debugger.debugSave("No filters provided for purge operation. Skipping for safety.");
                return;
            }
            Bson filter = Filters.and(filters);
            DeleteResult result = this.logEntries.deleteMany(filter);
            if (result.getDeletedCount() > 0L) {
                Debugger.debugSave("Purged " + result.getDeletedCount() + " logs in " + (System.currentTimeMillis() - start) + "ms");
            } else {
                Debugger.debugSave("No logs found to delete.");
            }
        });
        executor.shutdown();
    }

    @Override
    public CompletableFuture<CallbackLookup<List<ItemLogEntry>, Long>> getChestTransactions(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getChestTransactions(location, 0, Integer.MAX_VALUE).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(ItemLogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            List paginatedCachedLogs = cachedLogs.stream().skip(skip).limit(limit).collect(Collectors.toList());
            LinkedList result = new LinkedList(paginatedCachedLogs);
            int remaining = limit - paginatedCachedLogs.size();
            if (remaining > 0) {
                int effectiveSkipForDB = Math.max(0, skip - cachedLogs.size());
                int processedItemFromDB = 0;
                Set cachedItemKeys = cachedLogs.stream().map(ItemLogEntry::getItemStack).filter(Objects::nonNull).map(this::createItemKey).collect(Collectors.toSet());
                int addedFromDB = 0;
                int blockStart = 0;
                int blockSize = Math.max(10, remaining);
                long totalDBLogs = 0L;
                boolean hasMoreBlocks = true;
                while (addedFromDB < remaining && hasMoreBlocks) {
                    CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, blockStart, blockSize, ActionType.INVENTORY_TRANSACTION);
                    List dbLogs = dbLookup.getLogs().stream().filter(PlayerTransactionEntry.class::isInstance).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
                    if (dbLogs.isEmpty()) break;
                    int itemsAddedInThisBlock = 0;
                    block1: for (LogEntry log2 : dbLogs) {
                        String itemKey;
                        ItemStack item;
                        ItemTemplate itemTemplate;
                        PlayerTransactionEntry transaction = (PlayerTransactionEntry)log2;
                        if (addedFromDB >= remaining) {
                            totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                            break;
                        }
                        totalDBLogs += (long)(transaction.getAdded().size() + transaction.getRemoved().size());
                        for (Map.Entry<Long, Integer> addedEntry : transaction.getAdded().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) break;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(addedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), addedEntry.getValue(), true, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                        for (Map.Entry<Long, Integer> removedEntry : transaction.getRemoved().entrySet()) {
                            if (++processedItemFromDB <= effectiveSkipForDB) continue;
                            if (addedFromDB >= remaining) continue block1;
                            itemTemplate = this.stellarProtect.getItemsManager().getItemTemplate(removedEntry.getKey());
                            item = itemTemplate.getBukkitItem();
                            if (item == null || cachedItemKeys.contains(itemKey = this.createItemKey(item))) continue;
                            result.add(new ItemLogEntry(item, log2.getPlayerId(), removedEntry.getValue(), false, log2.getCreatedAt()));
                            ++addedFromDB;
                            ++itemsAddedInThisBlock;
                        }
                    }
                    if (itemsAddedInThisBlock == 0 && addedFromDB < remaining) {
                        if ((long)((blockStart += blockSize) + blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    if (addedFromDB < remaining && dbLogs.size() == blockSize) {
                        if ((long)(blockStart += blockSize) < totalDBLogs) continue;
                        hasMoreBlocks = false;
                        continue;
                    }
                    hasMoreBlocks = false;
                }
                long estimatedTotalCount = (long)cachedLogs.size() + totalDBLogs;
                return new CallbackLookup(result, estimatedTotalCount);
            }
            return new CallbackLookup(result, Long.valueOf(cachedLogs.size()));
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private String createItemKey(ItemStack item) {
        return item.getType() + ":" + item.getDurability() + ":" + (item.hasItemMeta() ? item.getItemMeta().toString() : "null");
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getLogs(@NonNull DatabaseFilters databaseFilters, int skip, int limit) {
        if (databaseFilters == null) {
            throw new NullPointerException("databaseFilters is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(databaseFilters, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(databaseFilters, dbSkip, remaining);
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            return new CallbackLookup<Map, Long>(groupedResults, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<CallbackLookup<Set<LogEntry>, Long>> getLogs(@NonNull Location location, int skip, int limit) {
        if (location == null) {
            throw new NullPointerException("location is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(LocationCache.of(location), skip, limit).stream().filter(log -> System.currentTimeMillis() - log.getCreatedAt() <= TimeUnit.MINUTES.toMillis(15L)).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            LinkedHashSet result = new LinkedHashSet(cachedLogs);
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Set<LogEntry>, Long> dbLookup = this.queryLogsFromDB(location, dbSkip, remaining, null);
                List dbLogs = dbLookup.getLogs().stream().filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                result.addAll(dbLogs);
                return new CallbackLookup(result, dbLookup.getTotal());
            }
            return new CallbackLookup(result, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private CallbackLookup<Set<LogEntry>, Long> queryLogsFromDB(Location location, int skip, int limit, @Nullable ActionType actionType) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        MongoCollection<Document> logCollection = this.database.getCollection("log_entries");
        long now = System.currentTimeMillis();
        long startTime = now - TimeUnit.DAYS.toMillis(30L);
        Bson filter = Filters.and(Filters.gte("created_at", startTime), Filters.lte("created_at", now), Filters.eq("x", location.getBlockX()), Filters.eq("y", location.getBlockY()), Filters.eq("z", location.getBlockZ()));
        if (actionType != null) {
            filter = Filters.and(filter, Filters.eq("action_type", actionType.getId()));
        }
        long total = logCollection.countDocuments(filter);
        FindIterable<Document> logDocs = logCollection.find(filter).sort(Sorts.descending("created_at")).skip(skip).limit(limit);
        for (Document doc : logDocs) {
            long playerId = doc.getLong("player_id");
            Document playerDoc = (Document)this.players.find(Filters.eq("id", playerId)).first();
            if (playerDoc != null) {
                String playerName = playerDoc.getString("name");
                PlayerCache.cacheName(playerId, playerName);
            }
            try {
                LogEntry entry = LogEntryFactory.fromDocument(doc);
                logs.add(entry);
            }
            catch (Exception e) {
                Debugger.debugLog("Error al convertir LogEntry: " + doc.toJson());
            }
        }
        return new CallbackLookup<Set<LogEntry>, Long>(logs, total);
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(DatabaseFilters databaseFilters, int skip, int limit) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        TimeArg timeArg = databaseFilters.getTimeFilter();
        RadiusArg radiusArg = databaseFilters.getRadiusFilter();
        UsersArg usersArg = databaseFilters.getUserFilters();
        List<Integer> actionTypes = databaseFilters.getActionTypesFilter();
        ArrayList<Bson> filters = new ArrayList<Bson>();
        if (timeArg != null) {
            filters.add(Filters.gte("created_at", timeArg.getStart()));
            filters.add(Filters.lte("created_at", timeArg.getEnd()));
        }
        if (radiusArg != null) {
            filters.add(Filters.gte("x", radiusArg.getMinX()));
            filters.add(Filters.lte("x", radiusArg.getMaxX()));
            filters.add(Filters.gte("y", radiusArg.getMinY()));
            filters.add(Filters.lte("y", radiusArg.getMaxY()));
            filters.add(Filters.gte("z", radiusArg.getMinZ()));
            filters.add(Filters.lte("z", radiusArg.getMaxZ()));
        }
        if (usersArg != null && usersArg.getUserIds() != null && !usersArg.getUserIds().isEmpty()) {
            filters.add(Filters.in("player_id", usersArg.getUserIds()));
        }
        if (actionTypes != null && !actionTypes.isEmpty()) {
            filters.add(Filters.in("action_type", actionTypes));
        }
        Bson filter = filters.isEmpty() ? new Document() : Filters.and(filters);
        long totalCount = this.logEntries.countDocuments(filter);
        FindIterable<Document> logDocs = this.logEntries.find(filter).sort(Sorts.descending("created_at")).skip(skip).limit(limit);
        for (Document doc : logDocs) {
            long playerId = doc.getLong("player_id");
            Document playerDoc = (Document)this.players.find(Filters.eq("id", playerId)).first();
            if (playerDoc != null) {
                String playerName = playerDoc.getString("name");
                PlayerCache.cacheName(playerId, playerName);
            }
            try {
                LogEntry entry = LogEntryFactory.fromDocument(doc);
                logs.add(entry);
            }
            catch (Exception e) {
                Debugger.debugLog("Error al cargar log: " + doc.toJson());
            }
        }
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }
}

