/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.mongo;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.callback.CallbackLookup;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.repositories.RestoreRepository;
import io.github.InsiderAnh.StellarProtect.database.types.factory.LogEntryFactory;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.libs.bson.conversions.Bson;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.FindIterable;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Filters;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Sorts;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class RestoreRepositoryMongo
implements RestoreRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final MongoDatabase database;
    private final MongoCollection<Document> players;
    private final MongoCollection<Document> logEntries;

    public RestoreRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.players = database.getCollection("players");
        this.logEntries = database.getCollection("log_entries");
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getRestoreActions(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, @NotNull List<ActionType> actionTypes, int skip, int limit) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(timeArg, radiusArg, actionTypes, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(timeArg, radiusArg, actionTypes, dbSkip, remaining);
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            return new CallbackLookup<Map, Long>(groupedResults, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<Long> countRestoreActions(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, @NotNull List<ActionType> actionTypes) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            long cachedCount = LoggerCache.countLogs(timeArg, radiusArg, actionTypes);
            long dbCount = this.countLogsFromDB(timeArg, radiusArg, actionTypes);
            return cachedCount + dbCount;
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private long countLogsFromDB(TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes) {
        List actionTypeNames = actionTypes.stream().map(ActionType::getId).collect(Collectors.toList());
        Bson filter = Filters.and(Filters.gte("created_at", timeArg.getStart()), Filters.lte("created_at", timeArg.getEnd()), Filters.gte("x", radiusArg.getMinX()), Filters.lte("x", radiusArg.getMaxX()), Filters.gte("y", radiusArg.getMinY()), Filters.lte("y", radiusArg.getMaxY()), Filters.gte("z", radiusArg.getMinZ()), Filters.lte("z", radiusArg.getMaxZ()), Filters.in("action_type", actionTypeNames));
        return this.logEntries.countDocuments(filter);
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes, int skip, int limit) {
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        List actionTypeNames = actionTypes.stream().map(ActionType::getId).collect(Collectors.toList());
        Bson filter = Filters.and(Filters.gte("created_at", timeArg.getStart()), Filters.lte("created_at", timeArg.getEnd()), Filters.gte("x", radiusArg.getMinX()), Filters.lte("x", radiusArg.getMaxX()), Filters.gte("y", radiusArg.getMinY()), Filters.lte("y", radiusArg.getMaxY()), Filters.gte("z", radiusArg.getMinZ()), Filters.lte("z", radiusArg.getMaxZ()), Filters.in("action_type", actionTypeNames));
        long totalCount = this.logEntries.countDocuments(filter);
        FindIterable<Document> logDocs = this.logEntries.find(filter).sort(Sorts.descending("created_at")).skip(skip).limit(limit);
        for (Document doc : logDocs) {
            long playerId = doc.getLong("player_id");
            Document playerDoc = (Document)this.players.find(Filters.eq("id", playerId)).first();
            if (playerDoc != null) {
                String playerName = playerDoc.getString("name");
                PlayerCache.cacheName(playerId, playerName);
            }
            try {
                LogEntry entry = LogEntryFactory.fromDocument(doc);
                logs.add(entry);
            }
            catch (Exception e) {
                Debugger.debugLog("Error al cargar log: " + doc.toJson());
            }
        }
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }
}

