/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.bson;

import io.github.InsiderAnh.StellarProtect.libs.bson.BSONCallback;
import io.github.InsiderAnh.StellarProtect.libs.bson.BSONDecoder;
import io.github.InsiderAnh.StellarProtect.libs.bson.BSONException;
import io.github.InsiderAnh.StellarProtect.libs.bson.BSONObject;
import io.github.InsiderAnh.StellarProtect.libs.bson.LazyBSONCallback;
import io.github.InsiderAnh.StellarProtect.libs.bson.io.Bits;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;

public class LazyBSONDecoder
implements BSONDecoder {
    private static final int BYTES_IN_INTEGER = 4;

    @Override
    public BSONObject readObject(byte[] bytes) {
        LazyBSONCallback bsonCallback = new LazyBSONCallback();
        this.decode(bytes, (BSONCallback)bsonCallback);
        return (BSONObject)bsonCallback.get();
    }

    @Override
    public BSONObject readObject(InputStream in) throws IOException {
        LazyBSONCallback bsonCallback = new LazyBSONCallback();
        this.decode(in, (BSONCallback)bsonCallback);
        return (BSONObject)bsonCallback.get();
    }

    @Override
    public int decode(byte[] bytes, BSONCallback callback) {
        try {
            return this.decode(new ByteArrayInputStream(bytes), callback);
        }
        catch (IOException e) {
            throw new BSONException("Invalid bytes received", e);
        }
    }

    @Override
    public int decode(InputStream in, BSONCallback callback) throws IOException {
        byte[] documentSizeBuffer = new byte[4];
        int documentSize = Bits.readInt(in, documentSizeBuffer);
        byte[] documentBytes = Arrays.copyOf(documentSizeBuffer, documentSize);
        Bits.readFully(in, documentBytes, 4, documentSize - 4);
        callback.gotBinary(null, (byte)0, documentBytes);
        return documentSize;
    }
}

