/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.bson.codecs;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonInvalidOperationException;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonReader;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonWriter;
import io.github.InsiderAnh.StellarProtect.libs.bson.assertions.Assertions;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.Codec;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.EncoderContext;

public class CharacterCodec
implements Codec<Character> {
    @Override
    public void encode(BsonWriter writer, Character value, EncoderContext encoderContext) {
        Assertions.notNull("value", value);
        writer.writeString(value.toString());
    }

    @Override
    public Character decode(BsonReader reader, DecoderContext decoderContext) {
        String string = reader.readString();
        if (string.length() != 1) {
            throw new BsonInvalidOperationException(String.format("Attempting to decode the string '%s' to a character, but its length is not equal to one", string));
        }
        return Character.valueOf(string.charAt(0));
    }

    @Override
    public Class<Character> getEncoderClass() {
        return Character.class;
    }
}

