/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb;

import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.Encoder;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.BulkUpdateRequestBuilder;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.BulkWriteOperation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.DBObject;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.RemoveRequest;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Collation;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.lang.Nullable;
import java.util.List;

public class BulkWriteRequestBuilder {
    private final BulkWriteOperation bulkWriteOperation;
    private final DBObject query;
    private final Encoder<DBObject> codec;
    private final Encoder<DBObject> replacementCodec;
    private Collation collation;

    BulkWriteRequestBuilder(BulkWriteOperation bulkWriteOperation, DBObject query, Encoder<DBObject> queryCodec, Encoder<DBObject> replacementCodec) {
        this.bulkWriteOperation = bulkWriteOperation;
        this.query = query;
        this.codec = queryCodec;
        this.replacementCodec = replacementCodec;
    }

    @Nullable
    public Collation getCollation() {
        return this.collation;
    }

    @Nullable
    public BulkWriteRequestBuilder collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public void remove() {
        this.bulkWriteOperation.addRequest(new RemoveRequest(this.query, true, this.codec, this.collation));
    }

    public void removeOne() {
        this.bulkWriteOperation.addRequest(new RemoveRequest(this.query, false, this.codec, this.collation));
    }

    public void replaceOne(DBObject document) {
        new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, false, this.codec, this.replacementCodec, this.collation, null).replaceOne(document);
    }

    public void update(DBObject update) {
        new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, false, this.codec, this.replacementCodec, this.collation, null).update(update);
    }

    public void updateOne(DBObject update) {
        new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, false, this.codec, this.replacementCodec, this.collation, null).updateOne(update);
    }

    public BulkUpdateRequestBuilder upsert() {
        return new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, true, this.codec, this.replacementCodec, this.collation, null);
    }

    public BulkUpdateRequestBuilder arrayFilters(List<? extends DBObject> arrayFilters) {
        return new BulkUpdateRequestBuilder(this.bulkWriteOperation, this.query, false, this.codec, this.replacementCodec, this.collation, arrayFilters);
    }
}

