/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb;

import io.github.InsiderAnh.StellarProtect.libs.bson.BSONObject;
import io.github.InsiderAnh.StellarProtect.libs.bson.BasicBSONEncoder;
import io.github.InsiderAnh.StellarProtect.libs.bson.io.OutputBuffer;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.BasicDBObject;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.DBEncoder;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.DBEncoderFactory;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.DBRef;

public class DefaultDBEncoder
extends BasicBSONEncoder
implements DBEncoder {
    public static final DBEncoderFactory FACTORY = new DBEncoderFactory(){

        @Override
        public DBEncoder create() {
            return new DefaultDBEncoder();
        }
    };

    @Override
    public int writeObject(OutputBuffer outputBuffer, BSONObject document) {
        this.set(outputBuffer);
        int x = this.putObject(document);
        this.done();
        return x;
    }

    @Override
    protected boolean putSpecial(String name, Object value) {
        if (value instanceof DBRef) {
            this.putDBRef(name, (DBRef)value);
            return true;
        }
        return false;
    }

    protected void putDBRef(String name, DBRef ref) {
        BasicDBObject dbRefDocument = new BasicDBObject("$ref", ref.getCollectionName()).append("$id", ref.getId());
        if (ref.getDatabaseName() != null) {
            dbRefDocument.put("$db", ref.getDatabaseName());
        }
        this.putObject(name, dbRefDocument);
    }

    public String toString() {
        return String.format("DBEncoder{class=%s}", this.getClass().getName());
    }
}

