/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoInternalException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoInterruptedException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.AsyncCompletionHandler;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;

class FutureAsyncCompletionHandler<T>
implements AsyncCompletionHandler<T> {
    private final CountDownLatch latch = new CountDownLatch(1);
    private volatile T result;
    private volatile Throwable error;

    FutureAsyncCompletionHandler() {
    }

    @Override
    public void completed(T result) {
        this.result = result;
        this.latch.countDown();
    }

    @Override
    public void failed(Throwable t) {
        this.error = t;
        this.latch.countDown();
    }

    public void getOpen() throws IOException {
        this.get("Opening");
    }

    public void getWrite() throws IOException {
        this.get("Writing to");
    }

    public T getRead() throws IOException {
        return this.get("Reading from");
    }

    private T get(String prefix) throws IOException {
        try {
            this.latch.await();
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException(prefix + " the AsynchronousSocketChannelStream failed", e);
        }
        if (this.error != null) {
            if (this.error instanceof IOException) {
                throw (IOException)this.error;
            }
            if (this.error instanceof MongoException) {
                throw (MongoException)this.error;
            }
            throw new MongoInternalException(prefix + " the AsynchronousSocketChannelStream failed", this.error);
        }
        return this.result;
    }
}

