/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.utils;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import java.util.concurrent.atomic.AtomicLong;
import lombok.NonNull;
import org.bukkit.entity.EntityType;

public class PlayerUtils {
    private static final BiMap<String, Long> specialIds = HashBiMap.create();

    public static void loadEntityIds() {
        AtomicLong entityId = new AtomicLong(-200L);
        for (EntityType entityType : EntityType.values()) {
            long id;
            String keyId = "=" + entityType.name().toLowerCase();
            if (specialIds.containsKey((Object)keyId) || specialIds.containsValue((Object)(id = entityId.getAndDecrement()))) continue;
            specialIds.put((Object)keyId, (Object)id);
            StellarProtect.getInstance().getProtectDatabase().saveEntityId(keyId, id);
        }
    }

    public static void cacheEntityId(String entityType, long entityId) {
        specialIds.put((Object)entityType, (Object)entityId);
    }

    public static long getPlayerOrEntityId(String name) {
        long id = PlayerProtect.getPlayerId(name);
        if (id != -2L) {
            return id;
        }
        return PlayerUtils.getEntityId(name);
    }

    public static long getEntityId(String entityType) {
        if (specialIds.containsKey((Object)entityType)) {
            return (Long)specialIds.get((Object)entityType);
        }
        return -2L;
    }

    @NonNull
    public static String getEntityType(long entityId) {
        if (specialIds.inverse().containsKey((Object)entityId)) {
            return (String)specialIds.inverse().get((Object)entityId);
        }
        return "=none";
    }

    static {
        specialIds.put((Object)"=natural", (Object)-2L);
        specialIds.put((Object)"=fire", (Object)-3L);
        specialIds.put((Object)"=water", (Object)-4L);
        specialIds.put((Object)"=lava", (Object)-5L);
        specialIds.put((Object)"=ice_melt", (Object)-6L);
        specialIds.put((Object)"=snow_fall", (Object)-7L);
        specialIds.put((Object)"=lightning", (Object)-8L);
        specialIds.put((Object)"=dripstone", (Object)-9L);
        specialIds.put((Object)"=piston", (Object)-10L);
        specialIds.put((Object)"=explosion", (Object)-11L);
        specialIds.put((Object)"=redstone", (Object)-12L);
        specialIds.put((Object)"=gravity", (Object)-13L);
        specialIds.put((Object)"=dispenser", (Object)-14L);
        specialIds.put((Object)"=observer", (Object)-15L);
        specialIds.put((Object)"=decay", (Object)-16L);
        specialIds.put((Object)"=portal", (Object)-17L);
    }
}

