/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.commands.arguments;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.ArgumentsParser;
import io.github.InsiderAnh.StellarProtect.arguments.LocationArg;
import io.github.InsiderAnh.StellarProtect.arguments.PageArg;
import io.github.InsiderAnh.StellarProtect.commands.StellarArgument;
import io.github.InsiderAnh.StellarProtect.data.InspectSession;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.utils.WorldUtils;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class NextInspectArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        LocationArg locationArg = ArgumentsParser.parseLocation(arguments);
        PageArg pageArg = ArgumentsParser.parsePage(arguments);
        if (locationArg == null) {
            this.plugin.getLangManager().sendMessage(sender, "messages.noLocation");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        InspectSession inspectSession = playerProtect.getInspectSession();
        if (inspectSession == null) {
            this.plugin.getLangManager().sendMessage(sender, "messages.noInspectSession");
            return;
        }
        if (playerProtect.getNextInspect() > System.currentTimeMillis()) {
            return;
        }
        playerProtect.setNextInspect(System.currentTimeMillis() + 500L);
        Location blockLocation = inspectSession.getLocation().getBlock().getLocation();
        playerProtect.setInspectSession(new InspectSession(blockLocation, pageArg.getSkip(), pageArg.getPerPage(), WorldUtils.isValidChestBlock(inspectSession.getLocation().getBlock().getType())));
        if (WorldUtils.isValidChestBlock(inspectSession.getLocation().getBlock().getType())) {
            this.plugin.getInspectHandler().handleChestInspection(player, blockLocation, pageArg.getPage(), pageArg.getSkip(), pageArg.getPerPage());
        } else {
            this.plugin.getInspectHandler().handleBlockInspection(player, blockLocation, pageArg.getPage(), pageArg.getSkip(), pageArg.getPerPage());
        }
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        return new ArrayList<String>();
    }
}

