/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.commands.arguments;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.ArgumentsParser;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.commands.StellarArgument;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class RestoreArgument
extends StellarArgument {
    private final StellarProtect plugin = StellarProtect.getInstance();

    @Override
    public void onCommand(@NotNull CommandSender sender, String[] arguments) {
        if (!(sender instanceof Player)) {
            this.plugin.getLangManager().sendMessage(sender, "messages.onlyPlayer");
            return;
        }
        Player player = (Player)sender;
        PlayerProtect playerProtect = PlayerProtect.getPlayer(player);
        if (playerProtect == null) {
            return;
        }
        TimeArg timeArg = ArgumentsParser.parseTime(arguments);
        RadiusArg radiusArg = ArgumentsParser.parseRadius(arguments, player.getLocation());
        List<ActionType> actionTypes = Arrays.asList(ActionType.BLOCK_BREAK, ActionType.BLOCK_PLACE, ActionType.INVENTORY_TRANSACTION);
        this.executeRestore(player, sender, timeArg, radiusArg, actionTypes);
    }

    @Override
    public List<String> onTabComplete(@NotNull CommandSender sender, String[] arguments) {
        if (arguments.length >= 1) {
            String currentArg = arguments[arguments.length - 1];
            if (currentArg.startsWith("t:") || currentArg.startsWith("time:")) {
                return Arrays.asList("t:1h", "t:1d", "t:1w", "t:1mo");
            }
            if (currentArg.startsWith("r:") || currentArg.startsWith("radius:")) {
                return Arrays.asList("r:10", "r:20", "r:30", "r:40", "r:50");
            }
        }
        return Arrays.asList("t:1h", "r:10");
    }

    public void executeRestore(Player player, CommandSender sender, TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes) {
        int BATCH_SIZE = 1000;
        int DELAY_TICKS = 2;
        ((CompletableFuture)this.plugin.getProtectDatabase().countRestoreActions(timeArg, radiusArg, actionTypes).thenAccept(totalLogs -> {
            if (totalLogs == 0L) {
                this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.noLogs");
                return;
            }
            player.sendMessage("\u00a7aIniciando rollback de \u00a7e" + totalLogs + "\u00a7a logs en lotes de \u00a7e" + 1000 + "\u00a7a...");
            this.processBatchRestore(sender, timeArg, radiusArg, actionTypes, 0, (long)totalLogs, 1000, 2);
        })).exceptionally(error -> {
            this.plugin.getLangManager().sendMessage((CommandSender)player, "messages.error");
            error.printStackTrace();
            return null;
        });
    }

    private void processBatchRestore(CommandSender sender, TimeArg timeArg, RadiusArg radiusArg, List<ActionType> actionTypes, int currentSkip, long totalLogs, int batchSize, int delayTicks) {
        if ((long)currentSkip >= totalLogs) {
            sender.sendMessage("\u00a7a\u00a1Rollback completado! Se procesaron \u00a7e" + totalLogs + "\u00a7a logs.");
            return;
        }
        ((CompletableFuture)this.plugin.getProtectDatabase().getRestoreActions(timeArg, radiusArg, actionTypes, currentSkip, batchSize).thenAccept(callbackLookup -> {
            Map groupedLogs = (Map)callbackLookup.getLogs();
            int processedInBatch = groupedLogs.values().stream().mapToInt(Set::size).sum();
            if (processedInBatch > 0) {
                this.plugin.getStellarTaskHook(() -> {
                    this.plugin.getRestoreManager().rollback(sender, groupedLogs);
                    int totalProcessed = currentSkip + processedInBatch;
                    double progress = (double)totalProcessed * 100.0 / (double)totalLogs;
                    sender.sendMessage(String.format("\u00a7bProgreso: \u00a7e%.1f%% \u00a77(\u00a7e%d\u00a77/\u00a7e%d\u00a77)", progress, totalProcessed, totalLogs));
                    this.plugin.getStellarTaskHook(() -> this.processBatchRestore(sender, timeArg, radiusArg, actionTypes, currentSkip + batchSize, totalLogs, batchSize, delayTicks)).runTask(delayTicks);
                }).runTask();
            } else {
                sender.sendMessage("\u00a7a\u00a1Rollback completado! Se procesaron \u00a7e" + currentSkip + "\u00a7a logs.");
            }
        })).exceptionally(error -> {
            sender.sendMessage("\u00a7cError en lote " + (currentSkip / batchSize + 1) + ": " + error.getMessage());
            error.printStackTrace();
            return null;
        });
    }
}

