/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.mongo;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.data.PlayerProtect;
import io.github.InsiderAnh.StellarProtect.database.repositories.PlayerRepository;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCollection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoCursor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.MongoDatabase;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Filters;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.FindOneAndUpdateOptions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.ReturnDocument;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.client.model.Updates;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.bukkit.entity.Player;

public class PlayerRepositoryMongo
implements PlayerRepository {
    private final MongoDatabase database;
    private final MongoCollection<Document> players;

    public PlayerRepositoryMongo(MongoDatabase database) {
        this.database = database;
        this.players = database.getCollection(StellarProtect.getInstance().getConfigManager().getTablesPlayers());
    }

    @Override
    public PlayerProtect loadOrCreatePlayer(Player player) {
        Document doc = (Document)this.players.find(Filters.eq("uuid", player.getUniqueId().toString())).first();
        if (doc != null) {
            return new PlayerProtect(player.getUniqueId(), player.getName(), doc.getLong("id"));
        }
        PlayerProtect playerProtect = new PlayerProtect(player.getUniqueId(), player.getName(), this.generateNextId());
        Document playerDoc = new Document("uuid", player.getUniqueId().toString()).append("name", player.getName().toLowerCase()).append("id", playerProtect.getPlayerId());
        this.players.insertOne(playerDoc);
        return playerProtect;
    }

    @Override
    public List<Long> getIdsByNames(List<String> names) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (names.isEmpty()) {
            return ids;
        }
        HashMap<String, Long> foundPlayers = new HashMap<String, Long>();
        try (MongoCursor cursor = this.players.find(Filters.in("name", names)).cursor();){
            while (cursor.hasNext()) {
                Document doc = (Document)cursor.next();
                Object idObj = doc.get("id");
                if (!(idObj instanceof Number)) continue;
                ids.add(((Number)idObj).longValue());
                foundPlayers.put(doc.getString("name").toLowerCase(), ((Number)idObj).longValue());
            }
        }
        for (String name : names) {
            if (foundPlayers.containsKey(name.toLowerCase())) continue;
            ids.add(-2L);
        }
        return ids;
    }

    @Override
    public long generateNextId() {
        Document result = this.database.getCollection("counters").findOneAndUpdate(Filters.eq("_id", "players"), Updates.inc("seq", 1), new FindOneAndUpdateOptions().upsert(true).returnDocument(ReturnDocument.AFTER));
        if (result != null && result.containsKey("seq")) {
            return result.getLong("seq");
        }
        throw new NullPointerException("No se pudo generar un nuevo ID para players.");
    }
}

