/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.types.sql;

import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.arguments.RadiusArg;
import io.github.InsiderAnh.StellarProtect.arguments.TimeArg;
import io.github.InsiderAnh.StellarProtect.cache.LoggerCache;
import io.github.InsiderAnh.StellarProtect.cache.PlayerCache;
import io.github.InsiderAnh.StellarProtect.cache.keys.LocationCache;
import io.github.InsiderAnh.StellarProtect.callback.CallbackLookup;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.database.repositories.RestoreRepository;
import io.github.InsiderAnh.StellarProtect.database.types.factory.LogEntryFactory;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.utils.Debugger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.jetbrains.annotations.NotNull;

public class RestoreRepositorySQL
implements RestoreRepository {
    private final StellarProtect stellarProtect = StellarProtect.getInstance();
    private final Connection connection;

    public RestoreRepositorySQL(Connection connection) {
        this.connection = connection;
    }

    @Override
    public CompletableFuture<CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>> getRestoreActions(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, @NotNull List<ActionType> actionTypes, int skip, int limit) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            List cachedLogs = LoggerCache.getLogs(timeArg, radiusArg, actionTypes, skip, limit).stream().sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).collect(Collectors.toList());
            Map groupedResults = cachedLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
            int remaining = limit - cachedLogs.size();
            if (remaining > 0) {
                int dbSkip = skip + cachedLogs.size();
                CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> dbLookup = this.queryLogsFromDB(timeArg, radiusArg, actionTypes, dbSkip, remaining);
                List dbLogs = dbLookup.getLogs().values().stream().flatMap(Collection::stream).filter(log -> cachedLogs.stream().noneMatch(c -> c.equals(log))).sorted(Comparator.comparingLong(LogEntry::getCreatedAt).reversed()).limit(remaining).collect(Collectors.toList());
                Map dbGrouped = dbLogs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
                dbGrouped.forEach((location, logs) -> groupedResults.merge(location, logs, (existing, newLogs) -> {
                    existing.addAll(newLogs);
                    return existing;
                }));
                return new CallbackLookup<Map, Long>(groupedResults, dbLookup.getTotal());
            }
            return new CallbackLookup<Map, Long>(groupedResults, (long)skip + (long)cachedLogs.size());
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    @Override
    public CompletableFuture<Long> countRestoreActions(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, @NotNull List<ActionType> actionTypes) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        return CompletableFuture.supplyAsync(() -> {
            long cachedCount = LoggerCache.countLogs(timeArg, radiusArg, actionTypes);
            long dbCount = this.countLogsFromDB(timeArg, radiusArg, actionTypes);
            return cachedCount + dbCount;
        }, (Executor)this.stellarProtect.getLookupExecutor());
    }

    private long countLogsFromDB(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, List<ActionType> actionTypes) {
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        String actionPlaceholders = actionTypes.stream().map(action -> "?").collect(Collectors.joining(","));
        String countQuery = "SELECT COUNT(*) FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " WHERE created_at BETWEEN ? AND ? AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ? AND action_type IN (" + actionPlaceholders + ")";
        long totalCount = 0L;
        try (PreparedStatement countStmt = this.connection.prepareStatement(countQuery);){
            int paramIndex = 1;
            countStmt.setLong(paramIndex++, timeArg.getStart());
            countStmt.setLong(paramIndex++, timeArg.getEnd());
            countStmt.setDouble(paramIndex++, radiusArg.getMinX());
            countStmt.setDouble(paramIndex++, radiusArg.getMaxX());
            countStmt.setDouble(paramIndex++, radiusArg.getMinY());
            countStmt.setDouble(paramIndex++, radiusArg.getMaxY());
            countStmt.setDouble(paramIndex++, radiusArg.getMinZ());
            countStmt.setDouble(paramIndex++, radiusArg.getMaxZ());
            for (ActionType actionType : actionTypes) {
                countStmt.setString(paramIndex++, actionType.name());
            }
            try (ResultSet resultSet = countStmt.executeQuery();){
                if (resultSet.next()) {
                    totalCount = resultSet.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in count", e);
        }
        return totalCount;
    }

    private CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long> queryLogsFromDB(@NonNull TimeArg timeArg, @NonNull RadiusArg radiusArg, @NonNull List<ActionType> actionTypes, int skip, int limit) {
        int paramIndex;
        if (timeArg == null) {
            throw new NullPointerException("timeArg is marked non-null but is null");
        }
        if (radiusArg == null) {
            throw new NullPointerException("radiusArg is marked non-null but is null");
        }
        if (actionTypes == null) {
            throw new NullPointerException("actionTypes is marked non-null but is null");
        }
        LinkedHashSet<LogEntry> logs = new LinkedHashSet<LogEntry>();
        long totalCount = 0L;
        String actionPlaceholders = actionTypes.stream().map(action -> "?").collect(Collectors.joining(","));
        String dataQuery = "SELECT ple.*, p.name, p.uuid FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " ple JOIN " + this.stellarProtect.getConfigManager().getTablesPlayers() + " p ON ple.player_id = p.id WHERE ple.created_at BETWEEN ? AND ? AND ple.x BETWEEN ? AND ? AND ple.y BETWEEN ? AND ? AND ple.z BETWEEN ? AND ? AND ple.action_type IN (" + actionPlaceholders + ") ORDER BY ple.created_at DESC LIMIT ? OFFSET ?";
        String countQuery = "SELECT COUNT(*) FROM " + this.stellarProtect.getConfigManager().getTablesLogEntries() + " WHERE created_at BETWEEN ? AND ? AND x BETWEEN ? AND ? AND y BETWEEN ? AND ? AND z BETWEEN ? AND ? AND action_type IN (" + actionPlaceholders + ")";
        try (PreparedStatement countStmt = this.connection.prepareStatement(countQuery);){
            paramIndex = 1;
            countStmt.setLong(paramIndex++, timeArg.getStart());
            countStmt.setLong(paramIndex++, timeArg.getEnd());
            countStmt.setDouble(paramIndex++, radiusArg.getMinX());
            countStmt.setDouble(paramIndex++, radiusArg.getMaxX());
            countStmt.setDouble(paramIndex++, radiusArg.getMinY());
            countStmt.setDouble(paramIndex++, radiusArg.getMaxY());
            countStmt.setDouble(paramIndex++, radiusArg.getMinZ());
            countStmt.setDouble(paramIndex++, radiusArg.getMaxZ());
            for (ActionType actionType : actionTypes) {
                countStmt.setString(paramIndex++, actionType.name());
            }
            try (ResultSet resultSet = countStmt.executeQuery();){
                if (resultSet.next()) {
                    totalCount = resultSet.getLong(1);
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in count", e);
        }
        try (PreparedStatement dataStmt = this.connection.prepareStatement(dataQuery);){
            paramIndex = 1;
            dataStmt.setLong(paramIndex++, timeArg.getStart());
            dataStmt.setLong(paramIndex++, timeArg.getEnd());
            dataStmt.setDouble(paramIndex++, radiusArg.getMinX());
            dataStmt.setDouble(paramIndex++, radiusArg.getMaxX());
            dataStmt.setDouble(paramIndex++, radiusArg.getMinY());
            dataStmt.setDouble(paramIndex++, radiusArg.getMaxY());
            dataStmt.setDouble(paramIndex++, radiusArg.getMinZ());
            dataStmt.setDouble(paramIndex++, radiusArg.getMaxZ());
            for (ActionType actionType : actionTypes) {
                dataStmt.setInt(paramIndex++, actionType.getId());
            }
            dataStmt.setInt(paramIndex++, limit);
            dataStmt.setInt(paramIndex++, skip);
            try (ResultSet rs = dataStmt.executeQuery();){
                while (rs.next()) {
                    long playerId = rs.getLong("player_id");
                    String playerName = rs.getString("name");
                    PlayerCache.cacheName(playerId, playerName);
                    logs.add(LogEntryFactory.fromDatabase(rs));
                }
            }
        }
        catch (SQLException e) {
            this.stellarProtect.getLogger().log(Level.SEVERE, "Error in queryLogsFromDB", e);
        }
        Debugger.debugLog("Loaded " + logs.size() + " logs from database.");
        Map groupedLogs = logs.stream().collect(Collectors.groupingBy(LocationCache::of, LinkedHashMap::new, Collectors.toCollection(LinkedHashSet::new)));
        return new CallbackLookup<Map<LocationCache, Set<LogEntry>>, Long>(groupedLogs, totalCount);
    }
}

