/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb;

import io.github.InsiderAnh.StellarProtect.libs.bson.BsonBinaryWriter;
import io.github.InsiderAnh.StellarProtect.libs.bson.BsonReader;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.Decoder;
import io.github.InsiderAnh.StellarProtect.libs.bson.codecs.DecoderContext;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.DBCollection;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.DBDecoder;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.DBObject;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoInternalException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.BufferProvider;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ByteBufferBsonOutput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

class DBDecoderAdapter
implements Decoder<DBObject> {
    private final DBDecoder decoder;
    private final DBCollection collection;
    private final BufferProvider bufferProvider;

    DBDecoderAdapter(DBDecoder decoder, DBCollection collection, BufferProvider bufferProvider) {
        this.decoder = decoder;
        this.collection = collection;
        this.bufferProvider = bufferProvider;
    }

    @Override
    public DBObject decode(BsonReader reader, DecoderContext decoderContext) {
        ByteBufferBsonOutput bsonOutput = new ByteBufferBsonOutput(this.bufferProvider);
        BsonBinaryWriter binaryWriter = new BsonBinaryWriter(bsonOutput);
        try {
            binaryWriter.pipe(reader);
            BufferExposingByteArrayOutputStream byteArrayOutputStream = new BufferExposingByteArrayOutputStream(binaryWriter.getBsonOutput().getSize());
            bsonOutput.pipe(byteArrayOutputStream);
            DBObject dBObject = this.decoder.decode(byteArrayOutputStream.getInternalBytes(), this.collection);
            return dBObject;
        }
        catch (IOException e) {
            throw new MongoInternalException("An unlikely IOException thrown.", e);
        }
        finally {
            binaryWriter.close();
            bsonOutput.close();
        }
    }

    private static class BufferExposingByteArrayOutputStream
    extends ByteArrayOutputStream {
        BufferExposingByteArrayOutputStream(int size) {
            super(size);
        }

        byte[] getInternalBytes() {
            return this.buf;
        }
    }
}

