/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.mongodb.MongoException;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.ServerAddress;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.assertions.Assertions;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ClusterId;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ClusterSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.connection.ClusterType;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.AbstractMultiServerCluster;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.ClusterableServerFactory;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DnsSrvRecordInitializer;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DnsSrvRecordMonitor;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.DnsSrvRecordMonitorFactory;
import java.util.Collection;
import java.util.Collections;

public final class DnsMultiServerCluster
extends AbstractMultiServerCluster {
    private final DnsSrvRecordMonitor dnsSrvRecordMonitor;
    private volatile MongoException srvResolutionException;

    public DnsMultiServerCluster(ClusterId clusterId, ClusterSettings settings, ClusterableServerFactory serverFactory, DnsSrvRecordMonitorFactory dnsSrvRecordMonitorFactory) {
        super(clusterId, settings, serverFactory);
        Assertions.notNull("srvHost", settings.getSrvHost());
        this.dnsSrvRecordMonitor = dnsSrvRecordMonitorFactory.create(settings.getSrvHost(), new DnsSrvRecordInitializer(){
            private volatile boolean initialized;

            @Override
            public void initialize(Collection<ServerAddress> hosts) {
                DnsMultiServerCluster.this.srvResolutionException = null;
                if (!this.initialized) {
                    this.initialized = true;
                    DnsMultiServerCluster.this.initialize(hosts);
                } else {
                    DnsMultiServerCluster.this.onChange(hosts);
                }
            }

            @Override
            public void initialize(MongoException initializationException) {
                if (!this.initialized) {
                    DnsMultiServerCluster.this.srvResolutionException = initializationException;
                    DnsMultiServerCluster.this.initialize(Collections.<ServerAddress>emptyList());
                }
            }

            @Override
            public ClusterType getClusterType() {
                return DnsMultiServerCluster.this.getClusterType();
            }
        });
        this.dnsSrvRecordMonitor.start();
    }

    @Override
    protected MongoException getSrvResolutionException() {
        return this.srvResolutionException;
    }

    @Override
    public void close() {
        if (this.dnsSrvRecordMonitor != null) {
            this.dnsSrvRecordMonitor.close();
        }
        super.close();
    }
}

