/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection;

import io.github.InsiderAnh.StellarProtect.libs.bson.io.BsonOutput;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.bulk.InsertRequest;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.LegacyMessage;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.MessageSettings;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.OpCode;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.connection.RequestMessage;
import io.github.InsiderAnh.StellarProtect.libs.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;

class InsertMessage
extends LegacyMessage {
    private final InsertRequest insertRequest;

    InsertMessage(String collectionName, InsertRequest insertRequest, MessageSettings settings) {
        super(collectionName, OpCode.OP_INSERT, settings);
        this.insertRequest = insertRequest;
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput outputStream) {
        this.writeInsertPrologue(outputStream);
        int firstDocumentPosition = outputStream.getPosition();
        this.addCollectibleDocument(this.insertRequest.getDocument(), outputStream, new CollectibleDocumentFieldNameValidator());
        return new RequestMessage.EncodingMetadata(firstDocumentPosition);
    }

    private void writeInsertPrologue(BsonOutput outputStream) {
        outputStream.writeInt32(0);
        outputStream.writeCString(this.getCollectionName());
    }
}

