/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.StellarProtect;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.utils.SerializerUtils;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.block.Block;

public class PlayerBlockLogEntry
extends LogEntry {
    private final String data;

    public PlayerBlockLogEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.data = jsonObject.get("d").getAsString();
    }

    public PlayerBlockLogEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.data = jsonObject.get("d").getAsString();
    }

    public PlayerBlockLogEntry(long playerId, Block block, ActionType actionType) {
        super(playerId, actionType.getId(), block.getLocation(), System.currentTimeMillis());
        this.data = StellarProtect.getInstance().getProtectNMS().getBlockData(block);
    }

    @Override
    public String getDataString() {
        return this.data;
    }

    @Override
    public String toSaveJson() {
        return "{\"d\":\"" + SerializerUtils.escapeJson(this.getData()) + "\"}";
    }

    @Generated
    public String getData() {
        return this.data;
    }
}

