/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;

public class PlayerDeathEntry
extends LogEntry {
    private final byte cause;

    public PlayerDeathEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.cause = jsonObject.get("c").getAsByte();
    }

    public PlayerDeathEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.cause = jsonObject.get("c").getAsByte();
    }

    public PlayerDeathEntry(long playerId, Location location, byte cause) {
        super(playerId, ActionType.DEATH.getId(), location, System.currentTimeMillis());
        this.cause = cause;
    }

    @Override
    public String getDataString() {
        return this.cause + "";
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerDeathEntry entry = this;
        obj.addProperty("c", (Number)entry.getCause());
        return obj.toString();
    }

    @Generated
    public byte getCause() {
        return this.cause;
    }
}

