/*
 * Decompiled with CFR 0.152.
 */
package io.github.InsiderAnh.StellarProtect.database.entries.players;

import com.google.gson.JsonObject;
import io.github.InsiderAnh.StellarProtect.database.entries.LogEntry;
import io.github.InsiderAnh.StellarProtect.enums.ActionType;
import io.github.InsiderAnh.StellarProtect.libs.bson.Document;
import io.github.InsiderAnh.StellarProtect.utils.WorldUtils;
import java.sql.ResultSet;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.entity.Entity;

public class PlayerHangingEntry
extends LogEntry {
    private final String entityType;

    public PlayerHangingEntry(Document document, JsonObject jsonObject) {
        super(document);
        this.entityType = jsonObject.get("et").getAsString();
    }

    public PlayerHangingEntry(ResultSet resultSet, JsonObject jsonObject) {
        super(resultSet);
        this.entityType = jsonObject.get("et").getAsString();
    }

    public PlayerHangingEntry(long playerId, Location location, Entity entity) {
        super(playerId, ActionType.HANGING.getId(), WorldUtils.getShortId(location.getWorld().getName()), location.getX(), location.getY(), location.getZ(), System.currentTimeMillis());
        this.entityType = entity.getType().name();
    }

    @Override
    public String getDataString() {
        return this.entityType;
    }

    @Override
    public String toSaveJson() {
        JsonObject obj = new JsonObject();
        PlayerHangingEntry entry = this;
        obj.addProperty("et", entry.getEntityType());
        return obj.toString();
    }

    @Generated
    public String getEntityType() {
        return this.entityType;
    }
}

